<?php
/**
 * Plugin Helper File
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
* Plugin that replaces stuff
*/
class plgSystemReReplacerHelper
{
	function init( &$params) {
		$this->params = $this->getParamValues( $this->params );
		
		$option = JRequest::getCmd( 'option' );

		$this->params->protect_start = '<!-- START: RR_PROTECT -->';
		$this->params->protect_end = '<!-- END: RR_PROTECT -->';

		$this->params->counter = array();

		$this->params->items_set = 0;

		$this->params->user =& JFactory::getUser();

		$this->params->default_item = new JParameter( '', JPATH_ADMINISTRATOR.DS.'components'.DS.'com_rereplacer'.DS.'item_params.xml' );
		$this->params->default_item = $this->getParamValues( $this->params->default_item );

		$this->params->items_all = $this->getItems( $this->params->default_item );

		require_once JPATH_SITE.DS.'plugins'.DS.'system'.DS.'nonumberelements'.DS.'helpers'.DS.'assignments.php';
		$this->params->assignments = new NoNumberElementsAssignmentsHelper;
	}

////////////////////////////////////////////////////////////////////
// ARTICLES
////////////////////////////////////////////////////////////////////

	function replaceInArticles ( &$article ) {
		$this->setItems( $article );

		foreach ( $this->params->items as $item ) {
			if ( $item->area == 'articles' ) {
				if ( isset( $article->text ) ) {
					$this->replace( $article->text, $item );
				}
				if ( isset( $article->description ) ) {
					$this->replace( $article->description, $item );
				}
				if ( isset( $article->title ) && $item->enable_in_title ) {
					$this->replace( $article->title, $item );
				}
				if ( isset( $article->author ) && $item->enable_in_author ) {
					if ( isset( $article->author->name ) ) {
						$this->replace( $article->author->name, $item );
					} else if ( is_string( $article->author ) ) {
						$this->replace( $article->author, $item );
					}
				}
			}
		}
	}

////////////////////////////////////////////////////////////////////
// COMPONENTS
////////////////////////////////////////////////////////////////////

	function replaceInComponents()
	{
		$this->setItems();
		
		$document	=& JFactory::getDocument();
		$docType = $document->getType();

		// FEED
		if ( $docType == 'feed' && isset( $document->items ) ) {
			for ( $i = 0; $i < count( $document->items ); $i++ ) {
				$this->replaceInArticles( $document->items[$i] );
			}
		}

		if ( isset( $document->_buffer ) ) {
			$this->tagArea( $document->_buffer, 'component' );
		}

		// PDF
		if ( $docType == 'pdf' ) {
			if ( isset( $document->_header ) ) {
				$this->replaceInTheRest( $document->_header );
				$this->cleanLeftoverJunk( $document->_header );
			}
			if ( isset( $document->title ) ) {
				$this->replaceInTheRest( $document->title );
				$this->cleanLeftoverJunk( $document->title );
			}
			if ( isset( $document->_buffer ) ) {
				$this->replaceInTheRest( $document->_buffer );
				$this->cleanLeftoverJunk( $document->_buffer );
			}
		}
	}

////////////////////////////////////////////////////////////////////
// OTHER AREAS
////////////////////////////////////////////////////////////////////
	function replaceInOtherAreas()
	{
		$document	=& JFactory::getDocument();
		$docType = $document->getType();

		// not in pdf's
		if ( $docType == 'pdf' ) { return; }

		$html = JResponse::getBody();
		$this->replaceInTheRest( $html );
		
		$this->cleanLeftoverJunk( $html );

		JResponse::setBody( $html );
	}

	function replaceInTheRest( &$str )
	{
		if ( $str == '' ) { return; }

		$document	=& JFactory::getDocument();
		$docType = $document->getType();

		// COMPONENT
		if ( $docType == 'feed' ) {
			$search_regex = '#(<item[^>]*>.*</item>)#si';
			$str = preg_replace( $search_regex, '<!-- START: RR_COMPONENT -->\1<!-- END: RR_COMPONENT -->', $str );
		}
		if ( strpos( $str, '<!-- START: RR_COMPONENT -->' ) === false ) {
			$this->tagArea( $str, 'component' );
		}

		$components = $this->getTagArea( $str, 'component' );
		foreach ( $components as $component ) {
			foreach ( $this->params->items as $item ) {
				if ( $item->area == 'component' ) {
					$this->replace( $component[1], $item );
				}
			}
			$str = str_replace( $component[0], $component[1], $str );
		}

		// BODY
		if ( !( strpos( $str, '</body>' ) === false ) ) {
			$search_regex = '#(<body[^>]*>)(.*)(</body>)#si';
			$str = preg_replace( $search_regex, '\1<!-- START: RR_BODY -->\2<!-- END: RR_BODY -->\3', $str );
		}
		if ( strpos( $str, '<!-- START: RR_BODY -->' ) === false ) {
			$search_regex = '#(<item[^>]*>.*</item>)#si';
			$str = preg_replace( $search_regex, '<!-- START: RR_BODY -->\1<!-- END: RR_BODY -->', $str );
		}
		if ( strpos( $str, '<!-- START: RR_BODY -->' ) === false ) {
			$this->tagArea( $str, 'body' );
		}

		$bodies =  $this->getTagArea( $str, 'body' );
		foreach ( $bodies as $body ) {
			foreach ( $this->params->items as $item ) {
				if ( $item->area == 'body' ) {
					$this->replace( $body[1], $item );
				}
			}
			$str = str_replace( $body[0], $body[1], $str );
		}

		// EVERYWHERE
		$this->replaceByArea( $str, 'everywhere' );

		// Remove any leftover protection strings (shouldn't be necessary, but just in case)
		$this->cleanProtect( $str );

		// Remove any leftover protection tags
		if ( !(strpos( $str, '{noreplace}' ) === false) ) {
			$item = '';
			$str_array = $this->stringToProtectedArray( $str, $item, 1 );
			$this->replaceInArray( $str_array, '#\{noreplace\}#s', '' );
			$this->replaceInArray( $str_array, '#\{/noreplace\}#s', '' );
			$str = implode( '', $str_array );
		}
	}

	function tagArea( &$str, $area = '' )
	{
		if ( $area ) {
			if ( is_array( $str ) ) {
				foreach ( $str as $key => $val ) {
					$this->tagArea( $val, $area );
					$str[ $key ] = $val;
				}
			} else if ( $str ) {
				$str = '<!-- START: RR_'.strtoupper( $area ).' -->'.$str.'<!-- END: RR_'.strtoupper( $area ).' -->';

				if ( $area == 'article_text' ) {
					$str = preg_replace( '#(<hr class="system-pagebreak".*?/>)#si', '<!-- END: RR_'.strtoupper( $area ).' -->\1<!-- START: RR_'.strtoupper( $area ).' -->', $str );
				}
			}
		}
	}

	function getTagArea( $str, $area = '' )
	{
		$matches = array( '', '' );

		if ( $str && $area ) {
			preg_match_all( '#<\!-- START: RR_'.strtoupper( $area ).' -->(.*?)<\!-- END: RR_'.strtoupper( $area ).' -->#s', $str, $matches, PREG_SET_ORDER );
		}
		return $matches;
	}

	function replaceByArea( &$str, $area = 'body' )
	{
		if ( is_array( $str ) ) {
			foreach ( $str as $key => $val ) {
				$str[$key] = $this->replaceByAreaReturn( $val, $area );
			}
		} else {
			foreach ( $this->params->items as $item ) {
				if ( $item->area == $area ) {
					$this->replace( $str, $item );
				}
			}
		}
	}
	function replaceByAreaReturn( $str, $area = '' )
	{
		$this->replaceByArea( $str, $area );
		return $str;
	}

	function replace( &$str, &$item )
	{
		if ( is_array( $str ) ) {
			foreach ( $str as $key => $val ) {
				$str[$key] = $this->replaceReturn( $val, $item );
			}
		} else {
			$this->protectVariables( $str );
			if ( $item->regex ) {
				$this->replaceRegEx( $str, $item );
			} else {
				$this->replaceString( $str, $item );
			}
			$this->replaceVariables( $str );
		}
	}
	function replaceReturn( $str, &$item )
	{
		$this->replace( $str, $item );
		return $str;
	}

	function replaceRegEx( &$str, &$item )
	{
		$str = str_replace( chr( 194 ).chr( 160 ), ' ', $str );
		$str_array = $this->stringToProtectedArray( $str, $item );

		$search = $item->search;
		$this->cleanString( $search );
		$search = '#'.$search.'#';
		if ( $item->s_modifier ) { $search .= 's'; } // . (dot) also matches newlines
		if ( !$item->casesensitive ) { $search .= 'i'; } // case-insensitive pattern matching

		$replace = $item->replace;
		$this->cleanStringReplace( $replace, 1 );
		$this->replaceInArray( $str_array, $search, $replace, $item->thorough );

		$str = implode( '', $str_array );
	}

	function replaceString( &$str, &$item )
	{
		$str_array = $this->stringToProtectedArray( $str, $item );

		$search_array = explode( ',', $item->search );
		$replace_array = explode( ',', $item->replace );
		$replace_count = count( $replace_array );

		foreach ( $search_array as $key => $search ) {
			if ( $search != '' ) {
				$this->cleanString( $search );
				$search = preg_quote( $search, "#" );
				if ( $item->word_search ) {
					$search = '(?<![a-zA-Z])('.$search.')(?![a-zA-Z])';
				}

				$search = '#'.$search.'#';
				$search .= 's'; // . (dot) also matches newlines
				if ( !$item->casesensitive ) { $search .= 'i'; } // case-insensitive pattern matching

				$replace = ( $replace_count > $key ) ? $replace_array[$key] : $replace_array['0'];
				$this->cleanStringReplace( $replace );

				$this->replaceInArray( $str_array, $search, $replace, $item->thorough );
			}
		}

		$str = implode( '', $str_array );
	}

	function replaceInArray( &$array, $search, $replace, $thorough = 0 )
	{
		foreach ( $array as $key => $val ) {
			// only do something if string is not empty
			// or on uneven count = not yet protected
			if ( trim( $val ) != '' && !fmod( $key, 2 ) ) {
				$this->replacer( $array[$key], $search, $replace, $thorough );
			}
		}
	}

	function replacer( &$str, $search, $replace, $thorough = 0 )
	{
		if ( preg_match( $search, $str ) ) {
			// Counter is used to make it possible to use \# in the replacement to refer to the incremental counter
			$counter_name = base64_encode( $search.$replace );
			if ( !isset( $this->params->counter[$counter_name] ) ) { $this->params->counter[$counter_name] = 0; }

			$offset = 0;
			$thorough_count = 1; // prevents the thorough search to repeat endlessly

			while ( preg_match( $search, $str, $matches, PREG_OFFSET_CAPTURE, $offset ) ) {
				$match = $matches[0];
				// Replace \# with the incremental counter
				$replace_c = str_replace( array( '\#', '[[counter]]' ), ++$this->params->counter[$counter_name], $replace );

				if ( !$thorough || $thorough_count == 1 ) {
					$prev_str_length = strlen( $str );
					$match_length = strlen( $match[0] );
					$match_offset = $match[1];
				}

				$str_part1 = substr( $str, 0, $offset );
				$str_part2 = substr( $str, $offset );
				$str = $str_part1.preg_replace( $search, $replace_c, $str_part2, 1 );
				$thorough_count++;

				if ( !$thorough || $thorough_count >= 100 ) {
					$offset = $match_offset + $match_length + ( strlen( $str ) - $prev_str_length );
					$thorough_count = 1;
					$prev_str_length = strlen( $str );
				}
			}
		}
	}

	function protect( $str, $protect = 1 )
	{
		if ( !$protect ) {
			return $this->params->protect_end.$str.$this->params->protect_start;
		} else {
			return $this->params->protect_start.$str.$this->params->protect_end;
		}
	}

	function stringToProtectedArray( $str, &$item, $onlyform = 0 )
	{
		$option = JRequest::getCmd( 'option' );
		$task = JRequest::getCmd( 'task' );

		$str_array = array( $str );

		if (
			$option == 'com_rereplacer' ||
			( $option == 'com_content' && $task == 'edit' ) ||
			$option == 'com_contentsubmit'
		) {
			// Protect complete adminForm (to prevent ReReplacer messing stuff up when editing articles and such)
			$search_regex = '(<form [^>]*name="adminForm".*?>.*?</form>)';
			// Protect search result
			$this->arrayProtectByRegex( $str_array, $search_regex, '', 1 );
		}

		if ( $onlyform ) {
			return $str_array;
		}

		// Protect everything between the {noreplace} tags
		$search_regex = '(\{noreplace\}.*?\{/noreplace\})';
		// Protect search result
		$this->arrayProtectByRegex( $str_array, $search_regex, '', 1 );

		// Protect everything outside the between tags
		if ( $item->between_start && $item->between_end ) {
			$search_regex = '(?<='.preg_quote( $item->between_start, "#" ).')(.*?)(?='.preg_quote( $item->between_end, "#" ).')';
			// Protect everything but search result
			$this->arrayProtectByRegex( $str_array, $search_regex, '', 0 );
		}

		// Protect all tags or everyting but tags
		if ( $item->enable_tags == 0 || $item->enable_tags == 2 ) {
			$search_regex = '(</?[a-zA-Z][^>]*>)';
			if ( $item->enable_tags == 0 ) {
				// no search permitted in tags, so all tags are protected
				// Protect search result
				$this->arrayProtectByRegex( $str_array, $search_regex, '', 1 );
				return $str_array;
			} else {
				// search only permitted in tags, so everything outside the tags is protected
				// Protect everything but search result
				$this->arrayProtectByRegex( $str_array, $search_regex, '', 0 );
			}
		}

		// removes unwanted whitespace from tag selection
		$item->tagselect = preg_replace( '#\s*(\[|\])\s*#', '\1', $item->tagselect );
		// removes unwanted params from tag selection
		// (if a asterisk is set, all other params for that tag name are redundant)
		$item->tagselect = preg_replace( '#\[[^\]]*?\*[^\]]*\]#', '[*]', $item->tagselect );

		// tag selection is not used (or tags selection permits all tags)
		if ( !$item->limit_tagselect || !(strpos( $item->tagselect, '*[*]' ) === false) ) {
			return $str_array;
		}

		// Convert tag selection to a nested array with trimmed tag names and params
		$tagselect = explode( ']', $item->tagselect );

		$search_tags = array();
		foreach ( $tagselect as $tag ) {
			if ( strlen( $tag ) ) {
				$tag_parts = explode( '[', $tag );
				$tag_name = trim( $tag_parts['0'] );
				$tag_params = array();
				if ( count( $tag_parts ) > 1 ) {
					$tag_params = $tag_parts['1'];
					// Trim and remove empty values
					$tag_params = array_diff( array_map( 'trim', explode( ',', $tag_params ) ), array('') );
					if ( in_array( '*', $tag_params ) ) {
						// Make array empty if asterisk is found
						// (the whole tag should be allowed)
						$tag_params = array();
					}
				}
				$search_tags[$tag_name] = $tag_params;
			}
		}

		// Tag selection is empty
		if ( !count( $search_tags ) ) {
			return $str_array;
		}

		$this->arrayProtectByTags( $str_array, $search_tags );

		return $str_array;
	}

	function arrayProtectByRegex( &$array, $search = '', $replace = '', $protect = 1, $convert = 1 )
	{
		$search = '#'.$search.'#si';
		if ( !$replace ) {
			$replace = '\1';
		}

		$is_array = is_array( $array );
		if ( !$is_array ) {
			$array = array( $array );
		}

		foreach ( $array as $key => $val ) {
			// only do something if string is not empty
			// or on uneven count = not yet protected
			if ( trim( $val ) != '' && !fmod( $key, 2 ) ) {
				if ( $protect ) {
					$val = preg_replace( $search, $this->protect( $replace ), $val );
				} else {
					$val = $this->protect( preg_replace( $search, $this->protect( $replace, 0 ), $val ) );
				}
				$this->cleanProtected( $val );
				$array[$key] = $val;
			}
		}

		if ( !$is_array ) {
			$array = $array[0];
		}

		if ( $convert ) {
			$array = $this->arrayProtect( $array );
		}
	}

	function arrayProtectByTags( &$array, &$tags, $convert = 1 )
	{
		foreach ( $array as $key => $val ) {
			// only do something if string is not empty
			// or on uneven count = not yet protected
			if ( trim( $val ) != '' && !fmod( $key, 2 ) ) {

				// First: protect all tags
				$search_regex = '(</?[a-zA-Z][^>]*>)';
				$this->arrayProtectByRegex( $val, $search_regex, '', 1, 0 );

				foreach ( $tags as $tag_name => $tag_params ) {
					if ( $tag_name == '*' ) {
						$tag_name = '[a-zA-Z][^> ]*';
					}
					if ( count( $tag_params ) ) {
						// only unprotect the parameter values
						foreach ( $tag_params as $tag_param ) {
							$search_regex = '(<'.$tag_name.' [^>]*'.$tag_param.'=")([^"]*)("[^>]*>)';
							$search_regex = '#'.$search_regex.'#si';
							$replace = '\1'.$this->protect( '\2', 0 ).'\3';
							$val = preg_replace( $search_regex, $replace, $val );
							$this->cleanProtected( $val );
						}

					} else {
						// unprotect the whole tag
						$search_regex = '(</?'.$tag_name.'( [^>]*)?>)';
						$this->arrayProtectByRegex( $val, $this->protect( $search_regex, 0 ), '', 1, 0 );
					}
				}
				$array[$key] = $val;
			}
		}

		if ( $convert ) {
			$array = $this->arrayProtect( $array );
		}
	}

	function cleanProtect( &$str )
	{
		$str = str_replace( array( $this->params->protect_start, $this->params->protect_end ), '', $str );

	}
	function cleanLeftoverJunk( &$str )
	{
		$str = preg_replace( '#<\!-- (START|END): RR_[^>]* -->#', '', $str );
		$this->cleanProtect( $str );
	}

	function cleanProtected( &$str )
	{
		while ( !( strpos( $str, $this->params->protect_start.$this->params->protect_start ) === false ) ) {
			$str = str_replace( $this->params->protect_start.$this->params->protect_start, $this->params->protect_start, $str );
		}
		while ( !( strpos( $str, $this->params->protect_end.$this->params->protect_end ) === false ) ) {
			$str = str_replace( $this->params->protect_end.$this->params->protect_end, $this->params->protect_end, $str );
		}
		while ( !( strpos( $str, $this->params->protect_end.$this->params->protect_start ) === false ) ) {
			$str = str_replace( $this->params->protect_end.$this->params->protect_start, '', $str );
		}

	}

	function arrayProtect( $array )
	{
		$new_array = array();

		foreach ( $array as $key => $val ) {
			// only do something if string is not empty
			// and is uneven count = not yet protected
			// and has protect start string
			if ( fmod( $key, 2 ) ) {
				// string is already protected
				$item_array = $this->protectStringToArray( $val, 1 );
			} else {
				// string is not yet protected
				$item_array = $this->protectStringToArray( $val );
			}
			foreach ( $item_array as $item_array_item ) {
				$new_array[] = $item_array_item;
			}
		}
		return $new_array;
	}

	function protectStringToArray( $str, $protected = 0 )
	{
		if ( $protected ) {
			// If already protected, just clean string and place in an array
			$this->cleanProtect( $str );
			$array = array ( $str );
		} else {
			// Return an array with 1 or 3 items.
			// 1) first part to protector start (if found) (= unprotected)
			// 2) part between the first protector start and its matching end (= protected)
			// 3) Rest of the string (= unprotected)

			$array = array();
			// Devide sting on protector start
			$str_array = explode( $this->params->protect_start, $str );
			// Add first element to the string ( = even = unprotected)
			$this->cleanProtect( $str_array[0] );
			$array[] = $str_array[0];

			$count = count( $str_array );
			if ( $count > 1 ) {
				for ( $i = 1; $i < $count; $i++ ) {
					$substr = $str_array[$i];
					$protect_count = 1;

					// Add the next string if not enough protector ends are found
					while (
						substr_count( $substr, $this->params->protect_end ) < $protect_count &&
						$i < ( $count - 1 )
					) {
						$protect_count++;
						$substr .= $str_array[++$i];
					}

					// Devide sting on protector end
					$substr_array = explode( $this->params->protect_end, $substr );

					$protect_part = '';
					// Add as many parts to the string as there are protector starts
					for ( $protect_i = 0; $protect_i < $protect_count; $protect_i++ ) {
						$protect_part .= array_shift( $substr_array );
						if ( !count( $substr_array ) ) {
							break;
						}
					}

					// This part is protected (uneven)
					$this->cleanProtect( $protect_part );
					$array[] = $protect_part;

					// The rest of the string is unprotected (even)
					$unprotect_part = implode( '', $substr_array );
					$this->cleanProtect( $unprotect_part );
					$array[] = $unprotect_part;
				}
			}
		}
		return $array;
	}

	function cleanString( &$str )
	{
		$str = str_replace( array( '[:space:]', '\[\:space\:\]', '[[space]]', '\[\[space\]\]' ), ' ', $str );
		$str = str_replace( array( '[:comma:]', '\[\:comma\:\]', '[[comma]]', '\[\[comma\]\]' ), ',', $str );
		$str = str_replace( array( '[:newline:]', '\[\:newline\:\]', '[[newline]]', '\[\[newline\]\]' ), "\n", $str );
		$str = str_replace( '[:REGEX_ENTER:]', '\\n', $str );
	}
	function cleanStringReplace( &$str, $is_regex = 0 )
	{
		if ( !$is_regex ) {
			$str = str_replace( '\\', '\\\\', $str );
			$str = str_replace( '\\\\#', '\\#', $str );
			$str = str_replace( '$', '\\$', $str );
		}
		$this->cleanString( $str );
	}

	function protectVariables( &$str )
	{
		$str = str_replace( array( '[[random:', '[[user:', '[[date:' ), array( '[[xrandom:', '[[xuser:', '[[xdate:' ), $str );
	}

	function replaceVariables( &$str )
	{
		if ( !( strpos( $str, '[[random' ) === false ) ) {
			while ( preg_match( '#\[\[random\:([0-9]+)-([0-9]+)\]\]#', $str, $match ) ) {
				$search = '#'.preg_quote( $match['0'], "#" ).'#';
				$replace = rand( (int) $match['1'], (int) $match['2'] );
				$str = preg_replace( $search, $replace, $str, 1 );
			}
		}
		if ( !( strpos( $str, '[[user' ) === false ) ) {
			if ( $this->params->user->id ) {
				$str = str_replace( '[[user:id]]', $this->params->user->id, $str );
				$str = str_replace( '[[user:username]]', $this->params->user->username, $str );
				$str = str_replace( '[[user:name]]', $this->params->user->name, $str );
			} else {
				$str = str_replace( '[[user:id]]', '', $str );
				$str = str_replace( '[[user:username]]', '', $str );
				$str = str_replace( '[[user:name]]', '', $str );
			}
		}
		if ( !( strpos( $str, '[[date' ) === false ) ) {
			if ( preg_match_all( '#\[\[date\:([^\]]+)\]\]#', $str, $matches, PREG_SET_ORDER ) > 0 ) {
				foreach ( $matches as $match ) {
					$replace = JHTML::_( 'date', time(), $match['1'] );
					$str = str_replace( $match['0'], $replace, $str );
				}
			}
		}
		$str = str_replace( array( '[[xrandom:', '[[xuser:', '[[xdate:' ), array( '[[random:', '[[user:', '[[date:' ), $str );
	}

	function setItems( $article = 0 )
	{
		if ( !$this->params->items_set ) {
			$mainframe =& JFactory::getApplication();
			$option = JRequest::getCmd( 'option' );

			$document	=& JFactory::getDocument();
			$docType = $document->getType();
			$option	= JRequest::getCmd( 'option' );

			$this->params->items = array();

			foreach ( $this->params->items_all as $key => $item ) {
				if (
					( $mainframe->isAdmin() && $item->enable_in_admin == 0 ) ||
					( !$mainframe->isAdmin() && $item->enable_in_admin == 2 ) ||
					( $docType == 'feed' && $item->enable_in_feeds == 0 ) ||
					( $docType != 'feed' && $item->enable_in_feeds == 2 )
				) {
					continue;
				}
				
				$params = array();
				if ( $item->assignto_menuitems ) {
					$params['MenuItem'] = '';
					$params['MenuItem']->assignment = $item->assignto_menuitems;
					$params['MenuItem']->selection = $item->assignto_menuitems_selection;
					$params['MenuItem']->params = '';
					$params['MenuItem']->params->inc_children = $item->assignto_menuitems_inc_children;
					$params['MenuItem']->params->inc_noItemid = $item->assignto_menuitems_inc_noitemid;
				}
				if ( $item->assignto_date ) {
					$params['Date'] = '';
					$params['Date']->assignment = $item->assignto_date;
					$params['Date']->params = '';
					$params['Date']->params->publish_up = $item->assignto_date_publish_up;
					$params['Date']->params->publish_ = $item->assignto_date_publish_down;
				}
				if ( $item->assignto_urls ) {
					$params['URL'] = '';
					$params['URL']->assignment = $item->assignto_urls;
					$params['URL']->selection = explode( "\\\n", $item->assignto_urls_selection );
				}
				if ( $item->assignto_usergrouplevels ) {
					$params['UserGroupLevels'] = '';
					$params['UserGroupLevels']->assignment = $item->assignto_usergrouplevels;
					$params['UserGroupLevels']->selection = $item->assignto_usergrouplevels_selection;
				}
				if ( $item->assignto_users ) {
					$params['Users'] = '';
					$params['Users']->assignment = $item->assignto_users;
					$params['Users']->selection = $item->assignto_users_selection;
				}
				if ( $item->assignto_components ) {
					$params['Components'] = '';
					$params['Components']->assignment = $item->assignto_components;
					$params['Components']->selection = $item->assignto_components_selection;
				}
				if ( $item->assignto_articles ) {
					$params['Articles'] = '';
					$params['Articles']->assignment = $item->assignto_articles;
					$params['Articles']->selection = $item->assignto_articles_selection;
				}
				if ( $item->assignto_secscats ) {
					$params['SecsCats'] = '';
					$params['SecsCats']->assignment = $item->assignto_secscats;
					$params['SecsCats']->selection = $item->assignto_secscats_selection;
					$params['SecsCats']->params = '';
					$incs = explode( ',', $item->assignto_secscats_inc );
					$params['SecsCats']->params->inc_sections = in_array( 'inc_secs', $incs );
					$params['SecsCats']->params->inc_categories = in_array( 'inc_cats', $incs );
					$params['SecsCats']->params->inc_articles = in_array( 'inc_arts', $incs );
					$params['SecsCats']->params->inc_others = in_array( 'inc_others', $incs );
				}
				if ( $item->assignto_languages ) {
					$params['Languages'] = '';
					$params['Languages']->assignment = $item->assignto_languages;
					$params['Languages']->selection = $item->assignto_languages_selection;
				}
				if ( $item->assignto_templates ) {
					$params['Templates'] = '';
					$params['Templates']->assignment = $item->assignto_templates;
					$params['Templates']->selection = $item->assignto_templates_selection;
				}
				if ( $item->assignto_php ) {
					$params['PHP'] = '';
					$params['PHP']->assignment = $item->assignto_php;
					$params['PHP']->selection = $item->assignto_php_selection;
				}

				if ( $item->assignto_k2cats && JFile::exists( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'admin.k2.php' ) ) {
					$params['Categories_K2'] = '';
					$params['Categories_K2']->assignment = $item->assignto_k2cats;
					$params['Categories_K2']->selection = $item->assignto_k2cats_selection;
					$params['Categories_K2']->params = '';
					$params['Categories_K2']->params->inc_children = $item->assignto_k2cats_inc_children;
					$incs = explode( ',', $item->assignto_k2cats_inc );
					$params['Categories_K2']->params->inc_categories = in_array( 'inc_cats', $incs );
					$params['Categories_K2']->params->inc_items = in_array( 'inc_items', $incs );
				}

				$pass = $this->params->assignments->passAll( $params, $item->match_method, $article );

				if ( !$pass && $item->other_doreplace ) {
					$item->replace = $item->other_replace;
					$pass = 1;
				}
				if ( $pass ) {
					$this->params->items[$key] = $item;
				}
			}
			if ( !$article ) {
				$this->params->items_set = 1;
			}
		}
	}

	function getItems( &$default_item )
	{
		$db =& JFactory::getDBO();
		$sql = "SELECT * FROM #__rereplacer
			WHERE published = 1
			ORDER BY ordering, id";
		$db->setQuery( $sql );
		$db_items = $db->loadObjectList();

		$items = array();
		
		if ( is_array( $db_items ) ) {
			foreach ( $db_items as $db_item ) {
				$item = clone( $default_item );

				foreach ( $db_item as $key => $val ) {
					if ( $key == 'params' ) {
						$params = new JRegistry();
						$params->loadINI( $val );
						$params = $params->toObject();
						foreach ( $params as $param_key => $param_val ) {
							if ( $param_key['0'] == '@' ) {
								continue;
							} else {
								$item->$param_key = html_entity_decoder( stripslashes( $param_val ) );
							}
						}
					} else if ( $key['0'] == '@' || ( $key == 'search' && strlen( $val ) < 3 ) ) {
						continue;
					} else {
						$item->$key = html_entity_decoder( stripslashes( $val ) );
					}
				}
				$items[] = $item;
			}
		}
		
		return $items;
	}

	function getParamValues( &$params ) {
		$values = '';
		if ( isset( $params->_xml ) ) {
			foreach ( $params->_xml as $xml_group ) {
				foreach ( $xml_group->children() as $xml_child ) {
					$key = $xml_child->attributes('name');
					if ( !empty( $key ) && $key['0'] != '@' ) {
						$val = $params->get( $key );
						if ( !is_array( $val ) && !strlen( $val ) ) {
							$val = $xml_child->attributes('default');
							if ( $xml_child->attributes('type') == 'textarea' ) {
								$val = str_replace( '<br />', "\n", $val );
							}
						}
						$values->$key = $val;
					}
				}
			}
		}
		return $values;
	}
}

if ( !function_exists( 'html_entity_decoder' ) ) {
	function html_entity_decoder( $given_html, $quote_style = ENT_QUOTES, $charset = 'UTF-8' )
	{
		if ( phpversion() < '5.0.0' ) {
			$trans_table = array_flip( get_html_translation_table( HTML_SPECIALCHARS, $quote_style ) );
			$trans_table['&#39;'] = "'";
			return ( strtr( $given_html, $trans_table ) );
		}else {
			return html_entity_decode( $given_html, $quote_style, $charset );
		}
	}
}

// PHP4 compatiblility for cloning objects
if ( phpversion() < '5.0.0' && !function_exists( 'clone' ) ) {
	eval('
		function clone( $object ) {
			return $object;
		}
	');
}