<?php
/**
 * @package    Advanced Module Manager
 * @version    1.5.0c
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/advancedmodulemanager
 * @copyright  Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

/**
 * BASE ON JOOMLA CORE FILE:
 * /libraries/joomla/application/module/helper.php
 * Altered / added parts are commented with: (C) NoNumber!
 */

/**
* @version		$Id: helper.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Application
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

// Import library dependencies
jimport('joomla.application.component.helper');

/**
 * Module helper class
 *
 * @static
 * @package		Joomla.Framework
 * @subpackage	Application
 * @since		1.5
 */
class JModuleHelper
{
	/**
	 * Get module by name (real, eg 'Breadcrumbs' or folder, eg 'mod_breadcrumbs')
	 *
	 * @access	public
	 * @param	string 	$name	The name of the module
	 * @param	string	$title	The title of the module, optional
	 * @return	object	The Module object
	 */
	function &getModule($name, $title = null )
	{
		$result		= null;
		$modules	=& JModuleHelper::_load();
		$total		= count($modules);
		for ($i = 0; $i < $total; $i++)
		{
			// Match the name of the module
			if ($modules[$i]->name == $name)
			{
				// Match the title if we're looking for a specific instance of the module
				if ( ! $title || $modules[$i]->title == $title )
				{
					$result =& $modules[$i];
					break;	// Found it
				}
			}
		}

		// if we didn't find it, and the name is mod_something, create a dummy object
		if (is_null( $result ) && substr( $name, 0, 4 ) == 'mod_')
		{
			$result				= new stdClass;
			$result->id			= 0;
			$result->title		= '';
			$result->module		= $name;
			$result->position	= '';
			$result->content	= '';
			$result->showtitle	= 0;
			$result->control	= '';
			$result->params		= '';
			$result->user		= 0;
		}

		return $result;
	}

	/**
	 * Get modules by position
	 *
	 * @access public
	 * @param string 	$position	The position of the module
	 * @return array	An array of module objects
	 */
	function &getModules($position)
	{
		$position	= strtolower( $position );
		$result		= array();

		$modules =& JModuleHelper::_load();

		$total = count($modules);
		for($i = 0; $i < $total; $i++) {
			if($modules[$i]->position == $position) {
				$result[] =& $modules[$i];
			}
		}
		if(count($result) == 0) {
			if(JRequest::getBool('tp')) {
				$result[0] = JModuleHelper::getModule( 'mod_'.$position );
				$result[0]->title = $position;
				$result[0]->content = $position;
				$result[0]->position = $position;
			}
		}

		return $result;
	}

	/**
	 * Checks if a module is enabled
	 *
	 * @access	public
	 * @param   string 	$module	The module name
	 * @return	boolean
	 */
	function isEnabled( $module )
	{
		$result = &JModuleHelper::getModule( $module);
		return (!is_null($result));
	}

	function renderModule($module, $attribs = array())
	{
		static $chrome;
		global $mainframe, $option;

		$scope = $mainframe->scope; //record the scope
		$mainframe->scope = $module->module;  //set scope to component name

		// Handle legacy globals if enabled
		if ($mainframe->getCfg('legacy'))
		{
			// Include legacy globals
			global $my, $database, $acl, $mosConfig_absolute_path;

			// Get the task variable for local scope
			$task = JRequest::getString('task');

			// For backwards compatibility extract the config vars as globals
			$registry =& JFactory::getConfig();
			foreach (get_object_vars($registry->toObject()) as $k => $v) {
				$name = 'mosConfig_'.$k;
				$$name = $v;
			}
			$contentConfig = &JComponentHelper::getParams( 'com_content' );
			foreach (get_object_vars($contentConfig->toObject()) as $k => $v)
			{
				$name = 'mosConfig_'.$k;
				$$name = $v;
			}
			$usersConfig = &JComponentHelper::getParams( 'com_users' );
			foreach (get_object_vars($usersConfig->toObject()) as $k => $v)
			{
				$name = 'mosConfig_'.$k;
				$$name = $v;
			}
		}

		// Get module parameters
		$params = new JParameter( $module->params );

		// Get module path
		$module->module = preg_replace('/[^A-Z0-9_\.-]/i', '', $module->module);
		$path = JPATH_BASE.DS.'modules'.DS.$module->module.DS.$module->module.'.php';

		// Load the module
		if (!$module->user && file_exists( $path ) && empty($module->content))
		{
			$lang =& JFactory::getLanguage();
			$lang->load($module->module);

			$content = '';
			ob_start();
			require $path;
			$module->content = ob_get_contents().$content;
			ob_end_clean();
		}

		// Load the module chrome functions
		if (!$chrome) {
			$chrome = array();
		}

		require_once (JPATH_BASE.DS.'templates'.DS.'system'.DS.'html'.DS.'modules.php');
		$chromePath = JPATH_BASE.DS.'templates'.DS.$mainframe->getTemplate().DS.'html'.DS.'modules.php';
		if (!isset( $chrome[$chromePath]))
		{
			if (file_exists($chromePath)) {
				require_once ($chromePath);
			}
			$chrome[$chromePath] = true;
		}

		//make sure a style is set
		if(!isset($attribs['style'])) {
			$attribs['style'] = 'none';
		}

		//dynamically add outline style
		if(JRequest::getBool('tp')) {
			$attribs['style'] .= ' outline';
		}

// >>> (C) NoNumber! >>>
		if ( $module->content == '' ) {
			$plugin = JPluginHelper::getPlugin( 'system', 'advancedmodules' );
			$plugin_params = new JParameter( $plugin->params );
			if ( $plugin_params->get( 'show_hideempty', 1 ) ) {
				$db =& JFactory::getDBO();
				$query = 'SELECT params'
					.' FROM #__advancedmodules'
					.' WHERE moduleid = '.(int) $module->id
					;
				$db->setQuery( $query );
				$adv_params = $db->loadResult();
				$adv_params = new JParameter( $adv_params );
				if ( $adv_params->get( 'hideempty', 0 ) ) {
					return '';
				}
			}
		}
// <<< (C) NoNumber! <<<

		foreach(explode(' ', $attribs['style']) as $style)
		{
			$chromeMethod = 'modChrome_'.$style;

			// Apply chrome and render module
			if (function_exists($chromeMethod))
			{
				$module->style = $attribs['style'];

				ob_start();
				$chromeMethod($module, $params, $attribs);
				$module->content = ob_get_contents();
				ob_end_clean();
			}
		}

		$mainframe->scope = $scope; //revert the scope

		return $module->content;
	}

	/**
	 * Get the path to a layout for a module
	 *
	 * @static
	 * @param	string	$module	The name of the module
	 * @param	string	$layout	The name of the module layout
	 * @return	string	The path to the module layout
	 * @since	1.5
	 */
	function getLayoutPath($module, $layout = 'default')
	{
		global $mainframe;

		// Build the template and base path for the layout
		$tPath = JPATH_BASE.DS.'templates'.DS.$mainframe->getTemplate().DS.'html'.DS.$module.DS.$layout.'.php';
		$bPath = JPATH_BASE.DS.'modules'.DS.$module.DS.'tmpl'.DS.$layout.'.php';

		// If the template has a layout override use it
		if (file_exists($tPath)) {
			return $tPath;
		} else {
			return $bPath;
		}
	}

	/**
	 * Load published modules
	 *
	 * @access	private
	 * @return	array
	 */

// >>> (C) NoNumber! >>>
	function &_load()
	{
		global $mainframe, $Itemid;

		static $modules;

		if (isset($modules)) {
			return $modules;
		}

		$user	=& JFactory::getUser();
		$db		=& JFactory::getDBO();

		$aid	= $user->get('aid', 0);

		$modules	= array();

		$select = 'm.*';
		$join = '';
		if ( $mainframe->getClientId() == 0 ) {
			$select .= ', am.params as adv_params';
			$join = ' LEFT JOIN #__advancedmodules as am'
				.' ON am.moduleid = m.id';
		}
		$query = 'SELECT '.$select
			.' FROM #__modules as m'
			.$join
			.' WHERE published = 1'
			.' AND m.access '.( defined( '_JACL' ) ? 'IN ('.$user->get( 'jaclplus', '0' ).')' : '<= '. (int) $aid )
			.' AND m.client_id = '. (int)$mainframe->getClientId()
			.' ORDER BY m.ordering, m.id';
		$db->setQuery( $query );

		if ( null === ( $modules = $db->loadObjectList( 'id' ) ) ) {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_( 'Error Loading Modules' ) . $db->getErrorMsg() );
			return false;
		}

		if ( $mainframe->getClientId() == 0 ) {
			$in_statement = implode( ', ', array_keys( $modules ) ) ;

			$query = 'SELECT menuid, moduleid'
				.' FROM #__advancedmodules_menu'
				.' WHERE moduleid IN (' . $in_statement . ')';
			$db->setQuery( $query );
			$advancedMenuItemList =& JModuleHelper::groupBy( $db->loadObjectList(), 'moduleid', 'menuid' );

			$query = 'SELECT menuid, moduleid'
				.' FROM #__modules_menu'
				.' WHERE moduleid IN (' . $in_statement . ')';
			$db->setQuery( $query );
			$coreMenuItemList =& JModuleHelper::groupBy( $db->loadObjectList(), 'moduleid', 'menuid' );

			$plugin = JPluginHelper::getPlugin( 'system', 'advancedmodules' );
			$plugin_params = new JParameter( $plugin->params );

			$limit_types = array();
			if ( $plugin_params->get( 'show_limit_date', 1 ) ) {
				$limit_types[] = 'Date';
			}
			if ( $plugin_params->get( 'show_limit_usergrouplevels', 1 ) ) {
				$limit_types[] = 'UserGroupLevels';
			}
			if ( $plugin_params->get( 'show_limit_components', 1 ) ) {
				$limit_types[] = 'Components';
			}
			if ( $plugin_params->get( 'show_limit_articles', 1 ) ) {
				$limit_types[] = 'Articles';
			}
			if ( $plugin_params->get( 'show_limit_secscats', 1 ) ) {
				$limit_types[] = 'SecsCats';
			}
			if ( $plugin_params->get( 'show_limit_languages', 1 ) ) {
				$limit_types[] = 'Languages';
			}
			if ( $plugin_params->get( 'show_limit_templates', 1 ) ) {
				$limit_types[] = 'Templates';
			}
			
			foreach ( $modules as $id => $module ) {
				$adv_params = new JParameter( $module->adv_params );

				if ( $plugin_params->get( 'show_mirror_module', 1 ) ) {
					$count = 0;
					while ( $count++ < 10 && $adv_params->get( 'mirror_module', 0 ) ) {
						$mirror_moduleid = $adv_params->get( 'mirror_moduleid' );
						$module->adv_params = '';
						if ( $mirror_moduleid && $mirror_moduleid != $id) {
							if ( isset( $modules[$mirror_moduleid] ) ) {
								$module->adv_params = $modules[$mirror_moduleid]->adv_params;
							} else {
								$query = 'SELECT params'
									.' FROM #__advancedmodules_menu'
									.' WHERE moduleid = '. (int) $mirror_moduleid
									.' LIMIT 1';
								$db->setQuery( $query );
								$module->adv_params = $db->loadResult();
							}
						}
						$adv_params = new JParameter( $module->adv_params );
					}
				}

				$match_method = $plugin_params->get( 'show_match_method', 1 ) ? $adv_params->get( 'match_method', 'and' ) : 'and';

				$pass = ( $match_method == 'and' ) ? 1 : 0;
				if ( isset( $Itemid ) ) {
					$lookup = isset( $advancedMenuItemList[$module->id] ) ? $advancedMenuItemList[$module->id] : array();
					if ( count( $lookup ) ) {
						if ( in_array( $Itemid, $lookup ) ) {
							$pass = 0;
						} else {
							$pass = 1;
							if ( $adv_params->get( 'on_children' ) ) {
								$parentids = JModuleHelper::getMenuItemParentIds( $Itemid );
								foreach ( $parentids as $parent ) {
									if ( in_array( $parent, $lookup ) ) {
										$pass = 0;
										break;
									}
								}
							}
						}
					} else {
						$lookup = isset( $coreMenuItemList[$module->id] ) ? $coreMenuItemList[$module->id] : array();
						if ( !in_array( $Itemid, $lookup ) && !in_array( '0', $lookup ) ) {
							$pass = 0;
							if ( $adv_params->get( 'on_children' ) ) {
								$parentids = JModuleHelper::getMenuItemParentIds( $Itemid );
								foreach ( $parentids as $parent ) {
									if ( in_array( $parent, $lookup ) ) {
										$pass = 1;
										break;
									}
								}
							}
						} else {
							if ( $match_method == 'or' && in_array( '0', $lookup ) ) {
								$pass = 0;
							} else {
								$pass = 1;
							}
						}
					}
				} else {
					// TODO: check if option for display on no Itemid is set
				}
				
				foreach ( $limit_types as $type ) {
					$func = 'pass'.$type;
					$type = strtolower( $type );

					if ( ( ( $pass && $match_method == 'and' ) || ( !$pass && $match_method == 'or' ) ) && $adv_params->get( 'limit_'.$type ) ) {
						if ( $type == 'date' ) {
							$pass = JModuleHelper::$func( $adv_params->get( 'limit_'.$type ), $adv_params->get( 'publish_up' ), $adv_params->get( 'publish_down' ) );
						} else {
							$pass = JModuleHelper::$func( $adv_params->get( 'limit_'.$type ), $adv_params->get( 'limit_'.$type.'_ids' ) );
						}
					}
				}

				if ( !$pass ) {
					unset( $modules[$id] );
				}
			}
		}

		$modules = array_values( $modules );

		$total = count($modules);
		for($i = 0; $i < $total; $i++)
		{
			//determine if this is a custom module
			$file					= $modules[$i]->module;
			$custom 				= substr( $file, 0, 4 ) == 'mod_' ?  0 : 1;
			$modules[$i]->user  	= $custom;
			// CHECK: custom module name is given by the title field, otherwise it's just 'om' ??
			$modules[$i]->name		= $custom ? $modules[$i]->title : substr( $file, 4 );
			$modules[$i]->style		= null;
			$modules[$i]->position	= strtolower($modules[$i]->position);
		}

		return $modules;
	}

	function groupBy( &$list, $fieldName, $fieldNameToKeep = null )
	{
		$grouped = array();
		if ( !is_array( $list ) ) {
			if ( $list == '' ) { return $grouped; }
			$list = array( $list );
		}
		foreach( $list as $item ) {
			if ( !isset( $grouped[$item->$fieldName] ) ) {
				$grouped[$item->$fieldName] = array();
			}
			if ( is_null( $fieldNameToKeep ) ) {
				$grouped[$item->$fieldName][] = $item;
			} else {
				$grouped[$item->$fieldName][] = $item->$fieldNameToKeep;
			}
		}

		return $grouped;
	}

	function passDate( $limit = 0, $publish_up = 0, $publish_down = 0 )
	{
		$now =& JFactory::getDate();
		$now = $now->toFormat();
		if ( $publish_up ) {
			$publish_up =& JFactory::getDate($publish_up);
			$publish_up = $publish_up->toFormat();
			if ( $publish_up > $now ) {
				return ( $limit == 2 ) ? 1 : 0;
			}
		}
		if ( $publish_down ) {
			$publish_down =& JFactory::getDate($publish_down);
			$publish_down = $publish_down->toFormat();
			if ( $publish_down < $now ) {
				return ( $limit == 2 ) ? 1 : 0;
			}
		}
		return ( $limit == 2 ) ? 0 : 1;
	}

	function passArticles( $limit = 0, $ids = array() )
	{
		global $option, $Itemid;
		$view = JRequest::getVar( 'view' );

		if ( $option != 'com_content' && $view != 'article' ) {
			return 0;
		}
		
		if ( $limit == -1 ) {
			return 0;
		}
		if ( !$limit ) {
			return 1;
		}

		if ( !is_array ( $ids ) ) {
			$ids = explode( ',', $ids );
		}
		if (!count( $ids ) ) {
			if ( $limit == 2 ) {
				return 1;
			} else {
				return 0;
			}
		}
		$id = JRequest::getInt( 'id' );
		if ( $id ) {
			$pass = 0;
			if ( in_array( $id, $ids ) ) {
				$pass = 1;
			}
			if (
					( !$pass && $limit == 1 )
				||	( $pass && $limit == 2 )
			) {
				return 0;
			}
		}

		return 1;
	}

	function passSecsCats( $limit = 0, $ids = array() )
	{
		global $option, $Itemid;

		if ( $option != 'com_content' ) {
			return 0;
		}

		if ( $limit == -1 ) {
				return 0;
		}
		if ( !$limit ) {
				return 1;
		}

		if ( !is_array ( $ids ) ) {
			$ids = explode( ',', $ids );
		}
		if (!count( $ids ) ) {
			if ( $limit == 2 ) {
				return 1;
			} else {
				return 0;
			}
		}
		$db =& JFactory::getDBO();

		$cats_lookup_all = array();
		$cats_lookup = array();
		$limit_cats = array();
		foreach ( $ids as $seccat ) {
			if ( strpos( $seccat, '.' ) === false ) {
				// section
				$query = 'SELECT id'.
					' FROM #__categories'.
					' WHERE published = 1'.
					' AND section = '.$seccat;
				$db->setQuery( $query );
				$categories = $db->loadResultArray();
				if ( !is_array( $categories ) ) {
					$categories = array();
				}
				$limit_cats = array_merge( $limit_cats, $categories );
				$cats_lookup[$seccat] = $categories;
				$cats_lookup_all[$seccat] = $categories;
			} else {
				// category
				$limit_cats[] = substr( $seccat, strpos( $seccat, '.' )+1 );
				$cats_lookup_all[substr( $seccat, 0, strpos( $seccat, '.' ) )][] = substr( $seccat, strpos( $seccat, '.' )+1 );
			}
		}

		$cat = '';
		$pass = 0;

		// Core Content
		$view = JRequest::getVar( 'view' );
		$id = JRequest::getInt( 'id' );

		if ( !$id ) {
			$menu = &JSite::getMenu();
			if (empty($Itemid)) {
				$menuItem = &$menu->getActive();
			} else {
				$menuItem = &$menu->getItem($Itemid);
			}
			$view = (empty($menuItem->query['view'])) ? null : $menuItem->query['view'];
			$id = (empty($menuItem->query['id'])) ? null : $menuItem->query['id'];
		}

		if( $view == 'article' ) {
			$article = &JTable::getInstance( 'content' );
			$article->load( $id );

			if ( $article->catid ) {
				$cat = $article->catid;
			} else {
				$catid					= JRequest::getInt( 'catid' );
				$filter_sectionid		= JRequest::getInt( 'filter_sectionid' );
				if ( $catid && $catid !== -1 ) {
					$cat = $catid;
				} else if ( $filter_sectionid !== '' &&  $filter_sectionid !== -1 ) {
					if ( isset( $cats_lookup_all[$filter_sectionid] ) ) {
						$pass = 1;
					}
				}
			}
		} else if ( $view == 'category' ) {
			$cat = $id;
		} else if ( $view == 'section' ) {
			if ( isset( $cats_lookup[$id] ) ) {
				$pass = 1;
			}
		}

		if ( in_array( $cat, $limit_cats ) ) {
			$pass = 1;
		}
		if (
			( !$pass && $limit == 1 )
			|| ($pass && $limit == 2 )
		) {
			return 0;
		}

		return 1;
	}

	function passTemplates( $limit = 0, $ids = array() )
	{
		global $mainframe;
		$template =& $mainframe->getTemplate();
		return JModuleHelper::passSimple( $template, $limit, $ids );
	}

	function passUserGroupLevels( $limit = 0, $ids = array() )
	{
		$user =& JFactory::getUser();
		return JModuleHelper::passSimple( $user->get( 'gid' ), $limit, $ids );
	}

	function passComponents( $limit = 0, $ids = array() )
	{
		$option = JRequest::getCmd( 'option' );
		return JModuleHelper::passSimple( $option, $limit, $ids );
	}

	function passLanguages( $limit = 0, $ids = array() )
	{
		$lang = JFactory::getLanguage();
		$lang = str_replace( '_', '-', $lang->_lang );
		return JModuleHelper::passSimple( $lang, $limit, $ids );
	}

	function passSimple( $value = '', $limit = 0, $ids = array() )
	{
		if ( !$limit ) {
				return 1;
		}
		if ( !is_array ( $ids ) ) {
			$ids = explode( ',', $ids );
		}
		if (
				( $limit == 1 && !in_array( $value, $ids ) )
			||	( $limit == 2 && in_array( $value, $ids ) )
		) {
			return 0;
		}
		return 1;
	}

	function getMenuItemParentIds( $menu_id = 0 )
	{
		$parent_ids = array();
		
		if ( !$menu_id ) {
			return $parent_ids;
		}

		$db	=& JFactory::getDBO();
		while ( $menu_id ) {
			$query = 'SELECT parent'
				.' FROM #__menu'
				.' WHERE id = '. (int) $menu_id
				.' LIMIT 1';
			$db->setQuery( $query );
			$menu_id = $db->loadResult();
			if ( $menu_id ) {
				$parent_ids[] = $menu_id;
			}
		}
		return $parent_ids;
	}
// <<< (C) NoNumber! <<<
}