--
-- Database query file
-- For manual installation
--
-- @package     ReReplacer
-- @version     2.6.5
--
-- @author      Peter van Westen <peter@nonumber.nl>
-- @link        http://www.nonumber.nl
-- @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
-- @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
--

--
-- NOTE: The queries assume you are using 'jos_' as the prefix.
--       Please change that if you are using another prefix.
--

--
-- Table structure for table `jos_rereplacer`
--
CREATE TABLE IF NOT EXISTS `#__rereplacer` (
	`id` int(11) unsigned NOT NULL auto_increment,
	`name` text NOT NULL,
	`description` text NOT NULL,
	`search` text NOT NULL,
	`replace` text NOT NULL,
	`params` text NOT NULL,
	`published` tinyint(1) unsigned NOT NULL default '0',
	`ordering` int(11) NOT NULL default '0',
	`checked_out` int(11) unsigned NOT NULL default '0',
	`checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
	PRIMARY KEY  (`id`),
	KEY `id` (`id`,`published`)
);

--
-- Insert the component record
--
INSERT INTO `jos_components` (`id`, `name`, `link`, `menuid`, `parent`, `admin_menu_link`, `admin_menu_alt`, `option`, `ordering`, `admin_menu_img`, `iscore`, `params`, `enabled`) VALUES
(NULL, 'ReReplacer', '', 0, 0, 'option=com_rereplacer', 'ReReplacer', 'com_rereplacer', 0, 'components/com_rereplacer/images/icon-rereplacer.png', 0, '', 1);

--
-- Insert the system plugin record
--
INSERT INTO `jos_plugins` (`id`, `name`, `element`, `folder`, `access`, `ordering`, `published`, `iscore`, `client_id`, `checked_out`, `checked_out_time`, `params`) VALUES
(NULL, 'System - ReReplacer', 'rereplacer', 'system', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', '');

--
-- Insert the system plugin record for NoNumber! Elements (if not exists)
--
INSERT IGNORE INTO `jos_plugins` (`id`, `name`, `element`, `folder`, `access`, `ordering`, `published`, `iscore`, `client_id`, `checked_out`, `checked_out_time`, `params`) VALUES
( ( SELECT `id` FROM `jos_plugins` as x WHERE x.`element` = 'nonumberelements' ), 'System - NoNumber! Elements', 'nonumberelements', 'system', 0, 0, 1, 0, 0, 0, 0, '');