<?php
/**
 * Extension Install File
 * Does the stuff for the specific extensions
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

$name = 'ReReplacer';
$alias = 'rereplacer';
$ext = $name.' (component & system plugin)';

// COMPONENT
$states[] = installExtension( $alias, $name, 'component', array( 'link'=>'', 'admin_menu_img'=>'components/com_'.$alias.'/images/icon-'.$alias.'.png' ) );

// SYSTEM PLUGIN
$states[] = installExtension( $alias, 'System - '.$name, 'plugin', array( 'folder'=>'system' ) );


// Stuff to do after installation / update
function afterInstall( &$db ) {
	// FIX STUFF FROM OLDER VERSIONS
	updateOldParams( $db );

	$queries = array();
	
	// main table
	$queries[] = "CREATE TABLE IF NOT EXISTS `#__rereplacer` (
	  `id` int(11) unsigned NOT NULL auto_increment,
	  `name` text NOT NULL,
	  `description` text NOT NULL,
	  `search` text NOT NULL,
	  `replace` text NOT NULL,
	  `params` text NOT NULL,
	  `published` tinyint(1) unsigned NOT NULL default '0',
	  `ordering` int(11) NOT NULL default '0',
	  `checked_out` int(11) unsigned NOT NULL default '0',
	  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
	  PRIMARY KEY  (`id`),
	  KEY `id` (`id`,`published`)
	)";

	// remove admin component link in menus (used for updating older versions)
	// update admin link icon
	$queries[] = "UPDATE `#__components`
		SET `link` = '',
			`admin_menu_img` = 'components/com_rereplacer/images/icon-rereplacer.png'
		WHERE `option` = 'com_rereplacer';";

	// Rename old component name
	$queries[] = "UPDATE `#__components`
		SET `name` = 'ReReplacer'
		WHERE `name` = 'ReReplacer!'";

	// Rename limit variables to new assignment names
	$queries[] = "UPDATE `#__rereplacer`
		SET	`params` = replace( replace( replace( replace( replace( replace( `params`,
			'\nlimit_', '\nassignto_' ),
			'\nsecscats=', '\nassignto_secscats_selection=' ),
			'\nitemids=', '\nassignto_menuitems_selection=' ),
			'\nlanguages=', '\nassignto_languages_selection=' ),
			'\nusergrouplevels=', '\nassignto_usergrouplevels_selection=' ),
			'\ntemplates=', '\nassignto_templates_selection=' );";

	// Update 'else, replace' fields with 1 overal fieldname
	$queries[] = "UPDATE `#__rereplacer`
		SET	`params` = replace( replace( replace( replace( replace( replace( replace( replace( replace( replace( `params`,
			'other_secscats_doreplace=0', '' ),
			'other_secscats_replace=\n', '' ),
			'other_itemids_doreplace=0', '' ),
			'other_itemids_replace=\n', '' ),
			'other_languages_doreplace=0', '' ),
			'other_languages_replace=\n', '' ),
			'other_usergrouplevels_doreplace=0', '' ),
			'other_usergrouplevels_replace=\n', '' ),
			'other_templates_doreplace=0', '' ),
			'other_templates_replace=\n', '' );";
	$queries[] = "UPDATE `#__rereplacer`
		SET	`params` = replace( replace( replace( replace( replace( replace( replace( replace( replace( replace( `params`,
			'other_secscats_doreplace=', 'other_doreplace=' ),
			'other_secscats_replace=', 'other_replace=' ),
			'other_itemids_doreplace=', 'other_doreplace=' ),
			'other_itemids_replace=', 'other_replace=' ),
			'other_languages_doreplace=', 'other_doreplace=' ),
			'other_languages_replace=', 'other_replace=' ),
			'other_usergrouplevels_doreplace=', 'other_doreplace=' ),
			'other_usergrouplevels_replace=', 'other_replace=' ),
			'other_templates_doreplace=', 'other_doreplace=' ),
			'other_templates_replace=', 'other_replace=' );";

	// Rename old plugin name
	$queries[] = "UPDATE `#__plugins`
		SET `name` = 'System - ReReplacer'
		WHERE `name` = 'System - ReReplacer!'";

	// remove the the wrongly created table from v2.6.3)
	$queries[] = "DROP TABLE IF EXISTS `#__`";

	foreach ( $queries as $query ) {
		$db->setQuery( $query );
		$db->query();
	}

}

function updateOldParams( &$db ) {
	// Attempt to fix old search/replace records
	$sql = 'SHOW TABLES LIKE "'.$db->_table_prefix.'rereplacer"';
	$db->setQuery( $sql );
	$exists = $db->loadResult();
	if ( $exists ) {
		$sql = 'SELECT * FROM #__rereplacer';
		$db->setQuery( $sql );
		$rows = $db->loadObjectList();
		$is_old = '';
		foreach ( $rows as $row) {
			if (	preg_match( "#\\\\\\\\(s\*|[1-9])#", $row->search )
				|| preg_match( "#\\\\\\\\(s\*|[1-9])#", $row->replace )
			) {
				$is_old = 'no';
				break;
			}
		}
		if ( $is_old != 'no' ) {
			foreach ( $rows as $row) {
				if (
						( preg_match( "#[^\\\\]\\\\(s\*|[1-9])#", $row->search ) || preg_match( "#^\\\\(s\*|[1-9])#", $row->search ) )
					||	( preg_match( "#[^\\\\]\\\\(s\*|[1-9])#", $row->replace ) || preg_match( "#^\\\\(s\*|[1-9])#", $row->replace ) )
				) {
					$is_old = 'yes';
					break;
				}
			}
			if ( $is_old == 'yes' ) {
				foreach ( $rows as $row) {
					$row->search = str_replace( '\\', '\\\\', $row->search );
					$row->replace = str_replace( '\\', '\\\\', $row->replace );

					$sql = 'UPDATE #__rereplacer SET'
						.' `search` = '.$db->quote( $row->search ).','
						.' `replace` = '.$db->quote( $row->replace )
						.' WHERE id = '.(int) $row->id;
					$db->setQuery( $sql );
					$db->query();
				}
			}
		}
	}
}