<?php
/**
 * @package    Advanced Module Manager
 * @version    0.2.2a
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/advancedmodulemanager
 * @copyright  Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

/**
 * BASE ON JOOMLA CORE FILE:
 * /administrator/components/com_modules/controller.php
 * Altered / added parts are commented with: (C) NoNumber!
 */

/**
 * @version		$Id: controller.php 11655 2009-03-08 20:04:17Z willebil $
 * @package		Joomla
 * @subpackage	Modules
 * @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

$client	= JRequest::getVar('client', 0, '', 'int');
// >>> (C) NoNumber! >>>
if ($client == 1) {
	JSubMenuHelper::addEntry(JText::_('Site'), 'index.php?option=com_advancedmodules&client_id=0');
	JSubMenuHelper::addEntry(JText::_('Administrator'), 'index.php?option=com_advancedmodules&client=1', true );
} else {
	JSubMenuHelper::addEntry(JText::_('Site'), 'index.php?option=com_advancedmodules&client_id=0', true );
	JSubMenuHelper::addEntry(JText::_('Administrator'), 'index.php?option=com_advancedmodules&client=1');
}
JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
// <<< (C) NoNumber! <<<

class ModulesController extends JController
{
	/**
	 * Constructor
	 */
	function __construct( $config = array() )
	{
		parent::__construct( $config );

		// Register Extra tasks
		$this->registerTask( 'apply', 			'save' );
		$this->registerTask( 'unpublish', 		'publish' );
		$this->registerTask( 'orderup', 		'reorder' );
		$this->registerTask( 'orderdown', 		'reorder' );
		$this->registerTask( 'accesspublic', 	'access' );
		$this->registerTask( 'accessregistered','access' );
		$this->registerTask( 'accessspecial',	'access' );
	}

	/**
	 * Compiles a list of installed or defined modules
	 */
	function view()
	{
		global $mainframe;

		// Initialize some variables
		$db		=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$option	= 'com_advancedmodules';
// <<< (C) NoNumber! <<<

		$filter_order		= $mainframe->getUserStateFromRequest( $option.'filter_order',		'filter_order',		'm.position',	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( $option.'filter_order_Dir',	'filter_order_Dir',	'',				'word' );
		$filter_state		= $mainframe->getUserStateFromRequest( $option.'filter_state',		'filter_state',		'',				'word' );
		$filter_position	= $mainframe->getUserStateFromRequest( $option.'filter_position',	'filter_position',	'',				'cmd' );
		$filter_type		= $mainframe->getUserStateFromRequest( $option.'filter_type',		'filter_type',		'',				'cmd' );
		$filter_assigned	= $mainframe->getUserStateFromRequest( $option.'filter_assigned',	'filter_assigned',	'',				'cmd' );
		$search				= $mainframe->getUserStateFromRequest( $option.'search',			'search',			'',				'string' );
		$search				= JString::strtolower( $search );

		$limit		= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart	= $mainframe->getUserStateFromRequest( $option.'.limitstart', 'limitstart', 0, 'int' );

		$where[] = 'm.client_id = '.(int) $client->id;

		$joins[] = 'LEFT JOIN #__users AS u ON u.id = m.checked_out';
		$joins[] = 'LEFT JOIN #__groups AS g ON g.id = m.access';
		$joins[] = 'LEFT JOIN #__modules_menu AS mm ON mm.moduleid = m.id';

		// used by filter
		if ( $filter_assigned ) {
			$joins[] = 'LEFT JOIN #__templates_menu AS t ON t.menuid = mm.menuid';
			$where[] = 't.template = '.$db->Quote($filter_assigned);
		}
		if ( $filter_position ) {
			$where[] = 'm.position = '.$db->Quote($filter_position);
		}
		if ( $filter_type ) {
			$where[] = 'm.module = '.$db->Quote($filter_type);
		}
		if ( $search ) {
			$where[] = 'LOWER( m.title ) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
		}
		if ( $filter_state ) {
			if ( $filter_state == 'P' ) {
				$where[] = 'm.published = 1';
			} else if ($filter_state == 'U' ) {
				$where[] = 'm.published = 0';
			}
		}

		$where 		= ' WHERE ' . implode( ' AND ', $where );
		$join 		= ' ' . implode( ' ', $joins );
		if ($filter_order == 'm.ordering') {
			$orderby = ' ORDER BY m.position, m.ordering '. $filter_order_Dir;
		} else {
			$orderby = ' ORDER BY '. $filter_order .' '. $filter_order_Dir .', m.ordering ASC';
		}

		// get the total number of records
		$query = 'SELECT COUNT(DISTINCT m.id)'
		. ' FROM #__modules AS m'
		. $join
		. $where
		;
		$db->setQuery( $query );
		$total = $db->loadResult();

		jimport('joomla.html.pagination');
		$pageNav = new JPagination( $total, $limitstart, $limit );

		$query = 'SELECT m.*, u.name AS editor, g.name AS groupname, MIN(mm.menuid) AS pages'
		. ' FROM #__modules AS m'
		. $join
		. $where
		. ' GROUP BY m.id'
		. $orderby
		;
		$db->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		$rows = $db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return false;
		}

		// get list of Positions for dropdown filter
		$query = 'SELECT m.position AS value, m.position AS text'
		. ' FROM #__modules as m'
		. ' WHERE m.client_id = '.(int) $client->id
		. ' GROUP BY m.position'
		. ' ORDER BY m.position'
		;
		$positions[] = JHTML::_('select.option',  '0', '- '. JText::_( 'Select Position' ) .' -' );
		$db->setQuery( $query );
		$positions = array_merge( $positions, $db->loadObjectList() );
		$lists['position']	= JHTML::_('select.genericlist', $positions, 'filter_position', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', "$filter_position" );

		// get list of Positions for dropdown filter
		$query = 'SELECT module AS value, module AS text'
		. ' FROM #__modules'
		. ' WHERE client_id = '.(int) $client->id
		. ' GROUP BY module'
		. ' ORDER BY module'
		;
		$db->setQuery( $query );
		$types[] 		= JHTML::_('select.option',  '0', '- '. JText::_( 'Select Type' ) .' -' );
		$types 			= array_merge( $types, $db->loadObjectList() );
		$lists['type']	= JHTML::_('select.genericlist', $types, 'filter_type', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', "$filter_type" );

		// state filter
		$lists['state']	= JHTML::_('grid.state', $filter_state );

		// template assignment filter
		$query = 'SELECT DISTINCT(template) AS text, template AS value'.
				' FROM #__templates_menu' .
				' WHERE client_id = '.(int) $client->id;
		$db->setQuery( $query );
		$assigned[]		= JHTML::_('select.option',  '0', '- '. JText::_( 'Select Template' ) .' -' );
		$assigned 		= array_merge( $assigned, $db->loadObjectList() );
		$lists['assigned']	= JHTML::_('select.genericlist', $assigned, 'filter_assigned', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', "$filter_assigned" );

		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;

		// search filter
		$lists['search']= $search;

// >>> (C) NoNumber! >>>
		require_once JApplicationHelper::getPath( 'admin_html' );
// <<< (C) NoNumber! <<<
		HTML_modules::view( $rows, $client, $pageNav, $lists );
	}

	/**
	* Compiles information to add or edit a module
	* @param string The current GET/POST option
	* @param integer The unique id of the record to edit
	*/
	function copy()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize some variables
		$db 	=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$cid	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$n		= count( $cid );

		if ($n == 0) {
			return JError::raiseWarning( 500, JText::_( 'No items selected' ) );
		}

		$row 	=& JTable::getInstance('module');
		$tuples	= array();

		foreach ($cid as $id)
		{
			// load the row from the db table
			$row->load( (int) $id );
			$row->title 		= JText::sprintf( 'Copy of', $row->title );
			$row->id 			= 0;
			$row->iscore 		= 0;
			$row->published 	= 0;

			if (!$row->check()) {
				return JError::raiseWarning( 500, $row->getError() );
			}
			if (!$row->store()) {
				return JError::raiseWarning( 500, $row->getError() );
			}
			$row->checkin();

			$row->reorder( 'position='.$db->Quote( $row->position ).' AND client_id='.(int) $client->id );

			$query = 'SELECT menuid'
			. ' FROM #__modules_menu'
			. ' WHERE moduleid = '.(int) $cid[0]
			;
			$db->setQuery( $query );
			$rows = $db->loadResultArray();

			foreach ($rows as $menuid) {
				$tuples[] = '('.(int) $row->id.','.(int) $menuid.')';
			}
		}

		if (!empty( $tuples ))
		{
			// Module-Menu Mapping: Do it in one query
			$query = 'INSERT INTO #__modules_menu (moduleid,menuid) VALUES '.implode( ',', $tuples );
			$db->setQuery( $query );
			if (!$db->query()) {
				return JError::raiseWarning( 500, $db->getError() );
			}
		}

		$msg = JText::sprintf( 'Items Copied', $n );
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='. $client->id, $msg );
// <<< (C) NoNumber! <<<
	}

	/**
	 * Saves the module after an edit form submit
	 */
	function save()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		global $mainframe;

		// Initialize some variables
		$db		=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$post	= JRequest::get( 'post' );
		// fix up special html fields
		$post['content']   = JRequest::getVar( 'content', '', 'post', 'string', JREQUEST_ALLOWRAW );
		$post['client_id'] = $client->id;

		$row =& JTable::getInstance('module');

		if (!$row->bind( $post, 'selections' )) {
			return JError::raiseWarning( 500, $row->getError() );
		}

		if (!$row->check()) {
			return JError::raiseWarning( 500, $row->getError() );
		}

		// if new item, order last in appropriate group
		if (!$row->id) {
			$where = 'position='.$db->Quote( $row->position ).' AND client_id='.(int) $client->id ;
			$row->ordering = $row->getNextOrder( $where );
		}

		if (!$row->store()) {
			return JError::raiseWarning( 500, $row->getError() );
		}
		$row->checkin();

// >>> (C) NoNumber! >>>
		$menus = JRequest::getVar( 'menus', '', 'post', 'word' );
		$selections = JRequest::getVar( 'selections', array(), 'post', 'array' );
		JArrayHelper::toInteger($selections);


		$advancedmodule =& JTable::getInstance( 'AdvancedModules', 'Table' );
		$query = 'SELECT id'
			. ' FROM #__advancedmodules'
			. ' WHERE moduleid = '. (int) $row->id
			. ' LIMIT 1'
			;
		$db->setQuery( $query );
		$advancedmodule->id = $db->loadResult();
		$advancedmodule->moduleid = $row->id;
		$advancedmodule->params = '';
		foreach ( JRequest::getVar( 'advancedparams' ) as $key => $val ) {
			if ( is_array( $val ) ) {
				$val = implode( '|', $val );
			}
			$advancedmodule->params .= $key.'='.$val."\n";
		}
		if (!$row->check()) {
			return JError::raiseWarning( 500, $row->getError() );
		}
		if (!$advancedmodule->store()) {
			return JError::raiseWarning( 500, $row->getError() );
		}
		$advancedmodule->checkin();
// <<< (C) NoNumber! <<<

		// delete old module to menu item associations
		$query = 'DELETE FROM #__modules_menu'
		. ' WHERE moduleid = '.(int) $row->id
		;
		$db->setQuery( $query );
		if (!$db->query()) {
			return JError::raiseWarning( 500, $db->getError() );
		}

// >>> (C) NoNumber! >>>
		// delete old exclude module to menu item associations (advancedmodules)
		$query = 'DELETE FROM #__advancedmodules_menu'
		. ' WHERE moduleid = '.(int) $row->id
		;
		$db->setQuery( $query );
		if (!$db->query()) {
			return JError::raiseWarning( 500, $db->getError() );
		}
// <<< (C) NoNumber! <<<

		// check needed to stop a module being assigned to `All`
		// and other menu items resulting in a module being displayed twice
		if ( $menus == 'all' ) {
			// assign new module to `all` menu item associations
			$query = 'INSERT INTO #__modules_menu'
			. ' SET moduleid = '.(int) $row->id.' , menuid = 0'
			;
			$db->setQuery( $query );
			if (!$db->query()) {
				return JError::raiseWarning( 500, $db->getError() );
			}
		}
		else
		{
// >>> (C) NoNumber! >>>
			if ( $menus == 'excludeselect' ) {
				foreach ($selections as $menuid)
				{
					// this check for the blank spaces in the select box that have been added for cosmetic reasons
					if ( (int) $menuid >= 0 ) {
						// assign new module to menu item associations
						$query = 'INSERT INTO #__advancedmodules_menu'
						. ' SET moduleid = '.(int) $row->id .', menuid = '.(int) $menuid
						;
						$db->setQuery( $query );
						if (!$db->query()) {
							return JError::raiseWarning( 500, $db->getError() );
						}
					}
				}

				// Flip the menu selection
				// So when Advanced Menus is disabled, the excluded items are unselected
				$query = 'SELECT id'
				. ' FROM #__menu'
				. ' WHERE published = 1'
				;
				$db->setQuery( $query );
				$menuitems = $db->loadResultArray();
				$selections = array_diff( $menuitems, $selections );
			}
// <<< (C) NoNumber! <<<

			foreach ($selections as $menuid)
			{
				// this check for the blank spaces in the select box that have been added for cosmetic reasons
				if ( (int) $menuid >= 0 ) {
					// assign new module to menu item associations
					$query = 'INSERT INTO #__modules_menu'
					. ' SET moduleid = '.(int) $row->id .', menuid = '.(int) $menuid
					;
					$db->setQuery( $query );
					if (!$db->query()) {
						return JError::raiseWarning( 500, $db->getError() );
					}
				}
			}
		}
		// clean cache for all 3 front-end user groups (guest, reg, special)
		$cache =& JFactory::getCache();
		$cache->remove($row->id . '0', $row->module);
		$cache->remove($row->id . '1', $row->module);
		$cache->remove($row->id . '2', $row->module);
		// clean content cache because of loadposition plugin
		$cache->clean( 'com_content' );

		$this->setMessage( JText::_( 'Item saved' ) );
		switch ($this->getTask())
		{
			case 'apply':
// >>> (C) NoNumber! >>>
				$link = 'index.php?option=com_advancedmodules&client='. $client->id .'&task=edit&id='. $row->id;
				if ( JRequest::getCmd( 'tmpl' ) ) {
					$link .= '&tmpl='.JRequest::getCmd( 'tmpl' );
				}
				$this->setRedirect( $link );
// <<< (C) NoNumber! <<<
				break;
		}
	}

	/**
	* Compiles information to add or edit a module
	* @param string The current GET/POST option
	* @param integer The unique id of the record to edit
	*/
	function edit( )
	{
		// Initialize some variables
		$db 	=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
		$module = JRequest::getVar( 'module', '', '', 'cmd' );
		$id 	= JRequest::getVar( 'id', 0, 'method', 'int' );
		$cid 	= JRequest::getVar( 'cid', array( $id ), 'method', 'array' );
		JArrayHelper::toInteger($cid, array(0));

		$model	= &$this->getModel('module');
		$model->setState( 'id',			$cid[0] );
		$model->setState( 'clientId',	$client->id );

		$lists 	= array();
		$row 	=& JTable::getInstance('module');
		// load the row from the db table
		$row->load( (int) $cid[0] );
		// fail if checked out not by 'me'
		if ($row->isCheckedOut( $user->get('id') )) {
// >>> (C) NoNumber! >>>
			$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<
			return JError::raiseWarning( 500, JText::sprintf( 'DESCBEINGEDITTED', JText::_( 'The module' ), $row->title ) );
		}

		$row->content = htmlspecialchars($row->content, ENT_COMPAT, 'UTF-8');

		if ( $cid[0] ) {
			$row->checkout( $user->get('id') );
		}
		// if a new record we must still prime the JTableModel object with a default
		// position and the order; also add an extra item to the order list to
		// place the 'new' record in last position if desired
		if ($cid[0] == 0) {
			$row->position 	= 'left';
			$row->showtitle = true;
			$row->published = 1;
			//$row->ordering = $l;

			$row->module 	= $module;
		}

		if ($client->id == 1)
		{
			$where 				= 'client_id = 1';
			$lists['client_id'] = 1;
			$path				= 'mod1_xml';
		}
		else
		{
			$where 				= 'client_id = 0';
			$lists['client_id'] = 0;
			$path				= 'mod0_xml';
		}

		$query = 'SELECT position, ordering, showtitle, title'
		. ' FROM #__modules'
		. ' WHERE '. $where
		. ' ORDER BY ordering'
		;
		$db->setQuery( $query );
		$orders = $db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return false;
		}

		$orders2 	= array();

		$l = 0;
		$r = 0;
		for ($i=0, $n=count( $orders ); $i < $n; $i++) {
			$ord = 0;
			if (array_key_exists( $orders[$i]->position, $orders2 )) {
				$ord =count( array_keys( $orders2[$orders[$i]->position] ) ) + 1;
			}

			$orders2[$orders[$i]->position][] = JHTML::_('select.option', $ord, $ord.'::'.addslashes( $orders[$i]->title ) );
		}

		// get selected pages for $lists['selections']
		if ( $cid[0] ) {
// >>> (C) NoNumber! >>>
			$query = 'SELECT menuid AS value'
			. ' FROM #__advancedmodules_menu'
			. ' WHERE moduleid = '.(int) $row->id
			;
			$db->setQuery( $query );
			$lookup = $db->loadObjectList();
			if ( !empty( $lookup ) ) {
				$row->pages = 'excludeselect';
			} else {
				$query = 'SELECT menuid AS value'
				. ' FROM #__modules_menu'
				. ' WHERE moduleid = '.(int) $row->id
				;
				$db->setQuery( $query );
				$lookup = $db->loadObjectList();

				if (empty( $lookup )) {
					$lookup = array( JHTML::_('select.option',  '-1' ) );
					$row->pages = 'none';
				} elseif (count($lookup) == 1 && $lookup[0]->value == 0) {
					$row->pages = 'all';
				} else {
					$row->pages = null;
				}
			}
// <<< (C) NoNumber! <<<
		} else {
			$lookup = array( JHTML::_('select.option',  0, JText::_( 'All' ) ) );
			$row->pages = 'all';
		}

		if ( $row->access == 99 || $row->client_id == 1 || $lists['client_id'] ) {
			$lists['access'] 			= 'Administrator';
			$lists['showtitle'] 		= 'N/A <input type="hidden" name="showtitle" value="1" />';
			$lists['selections'] 		= 'N/A';
		} else {
			if ( $client->id == '1' ) {
				$lists['access'] 		= 'N/A';
				$lists['selections'] 	= 'N/A';
			} else {
				$lists['access'] 		= JHTML::_('list.accesslevel', $row );

				$selections				= JHTML::_('menu.linkoptions');
				$lists['selections']	= JHTML::_('select.genericlist', $selections, 'selections[]', 'class="inputbox" size="15" multiple="multiple"', 'value', 'text', $lookup, 'selections' );
			}
			$lists['showtitle'] = JHTML::_('select.booleanlist',  'showtitle', 'class="inputbox"', $row->showtitle );
		}

		// build the html select list for published
		$lists['published'] = JHTML::_('select.booleanlist',  'published', 'class="inputbox"', $row->published );

// >>> (C) NoNumber! >>>
		if ( $client->id == 0 ) {
			$query = 'SELECT params'
				. ' FROM #__advancedmodules'
				. ' WHERE moduleid = '.(int) $row->id
				;
			$db->setQuery( $query );
			$advanced_params = $db->loadResult();
			$advanced_params = new JParameter( $advanced_params );
			$row->advancedparams = $advanced_params;

			$plugin = JPluginHelper::getPlugin( 'system', 'advancedmodules' );
			$plugin_params = new JParameter( $plugin->params );

			// also on children
				$lists['on_children'] = JHTML::_( 'select.booleanlist', 'advancedparams[on_children]', 'class="inputbox"', $advanced_params->get( 'on_children', 0 ), 'yes', 'no', 'advancedparamson_children' );

			// hide if empty
			if ( $plugin_params->get( 'show_hideempty', 1 ) ) {
				$lists['hideempty'] = JHTML::_( 'select.booleanlist', 'advancedparams[hideempty]', 'class="inputbox"', $advanced_params->get( 'hideempty', 0 ), 'yes', 'no', 'advancedparamshideempty' );
			}

			// mirror module
			if ( $plugin_params->get( 'show_mirror_module', 1 ) ) {
				$lists['mirror_module'] = JHTML::_( 'select.booleanlist', 'advancedparams[mirror_module]', 'class="inputbox"', $advanced_params->get( 'mirror_module', 0 ), 'yes', 'no', 'advancedparamsmirror_module' );
				$lists['mirror_moduleid'] = '<input class="text_area" type="text" name="advancedparams[mirror_moduleid]" id="advancedparamsmirror_moduleid" size="20" value="'.$advanced_params->get( 'mirror_moduleid' ).'" />';
			}

			// match method
			if ( $plugin_params->get( 'show_match_method', 1 ) ) {
				$options = array();
				$options[] = JHTML::_( 'select.option', 'and', JText::_( '-AND-' ) );
				$options[] = JHTML::_( 'select.option', 'or', JText::_( '-OR-' ) );
				$lists['match_method'] = JHTML::_( 'select.radiolist', $options, 'advancedparams[match_method]', 'class="inputbox"', 'value', 'text', $advanced_params->get( 'match_method', $plugin_params->get( 'match_method', 'and' ) ), 'advancedparamsmatch_method' );
			}

			// limit date
			if ( $plugin_params->get( 'show_limit_date', 1 ) ) {
				$lists['publish_up'] = $this->fetchElementCalander( 'publish_up', $advanced_params->get( 'publish_up' ) );
				$lists['publish_down'] = $this->fetchElementCalander( 'publish_down', $advanced_params->get( 'publish_down' ) );
			}
			// limit seccats
			if ( $plugin_params->get( 'show_limit_seccats', 1 ) ) {
				$lists['seccats'] = $this->fetchElementSecCats( 'limit_seccats_ids', $advanced_params->get( 'limit_seccats_ids' ) );
			}
			// limit articles
			if ( $plugin_params->get( 'show_limit_articles', 1 ) ) {
				$lists['articles'] = $this->fetchElementArticles( 'limit_articles_ids', $advanced_params->get( 'limit_articles_ids' ) );
			}
			// limit usergrouplevels
			if ( $plugin_params->get( 'show_limit_usergrouplevels', 1 ) ) {
				$lists['usergrouplevels'] = $this->fetchElementUserGroupLevels( 'limit_usergrouplevels_ids', $advanced_params->get( 'limit_usergrouplevels_ids' ) );
			}
			// limit components
			if ( $plugin_params->get( 'show_limit_components', 1 ) ) {
				$lists['components'] = $this->fetchElementComponents( 'limit_components_ids', $advanced_params->get( 'limit_components_ids' ) );
			}
			// limit components
			if ( $plugin_params->get( 'show_limit_languages', 1 ) ) {
				$lists['languages'] = $this->fetchElementLanguages( 'limit_languages_ids', $advanced_params->get( 'limit_languages_ids' ) );
			}
			// limit components
			if ( $plugin_params->get( 'show_limit_templates', 1 ) ) {
				$lists['templates'] = $this->fetchElementTemplates( 'limit_templates_ids', $advanced_params->get( 'limit_templates_ids' ) );
			}
		}
// <<< (C) NoNumber! <<<

		$row->description = '';

		$lang =& JFactory::getLanguage();
		if ( $client->id != '1' ) {
			$lang->load( trim($row->module), JPATH_SITE );
		} else {
			$lang->load( trim($row->module) );
		}

		// xml file for module
		if ($row->module == 'custom') {
			$xmlfile = JApplicationHelper::getPath( $path, 'mod_custom' );
		} else {
			$xmlfile = JApplicationHelper::getPath( $path, $row->module );
		}

		$data = JApplicationHelper::parseXMLInstallFile($xmlfile);
		if ($data)
		{
			foreach($data as $key => $value) {
				$row->$key = $value;
			}
		}

		// get params definitions
		$params = new JParameter( $row->params, $xmlfile, 'module' );

// >>> (C) NoNumber! >>>
		require_once JApplicationHelper::getPath( 'admin_html' );
// <<< (C) NoNumber! <<<
		HTML_modules::edit( $model, $row, $orders2, $lists, $params, $client );
	}

	/**
	* Displays a list to select the creation of a new module
	*/
	function add()
	{
		global $mainframe;

		// Initialize some variables
		$modules	= array();
		$client		=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));

		// path to search for modules
		if ($client->id == '1') {
			$path		= JPATH_ADMINISTRATOR.DS.'modules';
			$langbase	= JPATH_ADMINISTRATOR;
		} else {
			$path		= JPATH_ROOT.DS.'modules';
			$langbase	= JPATH_ROOT;
		}

		jimport('joomla.filesystem.folder');
		$dirs = JFolder::folders( $path );
		$lang =& JFactory::getLanguage();

		foreach ($dirs as $dir)
		{
			if (substr( $dir, 0, 4 ) == 'mod_')
			{
				$files 				= JFolder::files( $path.DS.$dir, '^([_A-Za-z0-9]*)\.xml$' );
// >>> (C) NoNumber! >>>
				if( count( $files ) ) {
					$module				= new stdClass;
					$module->file 		= $files[0];
					$module->module 	= str_replace( '.xml', '', $files[0] );
					$module->path 		= $path.DS.$dir;
					$modules[]			= $module;

					$lang->load( $module->module, $langbase );
				}
// <<< (C) NoNumber! <<<
			}
		}

// >>> (C) NoNumber! >>>
		require_once JPATH_COMPONENT.DS.'helpers'.DS.'xml.php';
// <<< (C) NoNumber! <<<
		ModulesHelperXML::parseXMLModuleFile( $modules, $client );

		$n = count($modules);
		for ($i = 0; $i < $n; $i++) {
			$modules[$i]->name = JText::_(stripslashes($modules[$i]->name));
		}

		// sort array of objects alphabetically by name
		JArrayHelper::sortObjects( $modules, 'name' );

// >>> (C) NoNumber! >>>
		require_once JApplicationHelper::getPath( 'admin_html' );
// <<< (C) NoNumber! <<<
		HTML_modules::add( $modules, $client );
	}

	/**
	* Deletes one or more modules
	*
	* Also deletes associated entries in the #__module_menu table.
	* @param array An array of unique category id numbers
	*/
	function remove()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize some variables
		$db		=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$cid	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger( $cid );

		if (empty( $cid )) {
			return JError::raiseWarning( 500, 'No items selected' );
		}

		$cids = implode( ',', $cid );

		// pasamio: Disabled this as it breaks the uninstall ability!
		/*$query = 'SELECT id, module, title, iscore, params'
		. ' FROM #__modules WHERE id IN ('.$cids.')'
		;
		$db->setQuery( $query );
		if (!($rows = $db->loadObjectList())) {
			return JError::raiseError( 500, $db->getErrorMsg() );
		}*/

		// remove mappings first (lest we leave orphans)
		$query = 'DELETE FROM #__modules_menu'
			. ' WHERE moduleid IN ( '.$cids.' )'
			;
		$db->setQuery( $query );
		if (!$db->query()) {
			return JError::raiseError( 500, $db->getErrorMsg() );
		}
		// remove module
		$query = 'DELETE FROM #__modules'
			. ' WHERE id IN ('.$cids.')'
			;
		$db->setQuery( $query );
		if (!$db->query()) {
			return JError::raiseError( 500, $db->getErrorMsg() );
		}

		$this->setMessage( JText::sprintf( 'Items removed', count( $cid ) ) );
	}

	/**
	* Publishes or Unpublishes one or more modules
	*/
	function publish()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize some variables
		$db 	=& JFactory::getDBO();
		$user 	=& JFactory::getUser();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$cache = & JFactory::getCache();
		$cache->clean( 'com_content' );

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		$task	= $this->getTask();
		$publish	= ($task == 'publish');

		if (empty( $cid )) {
			return JError::raiseWarning( 500, 'No items selected' );
		}

		$cids = implode( ',', $cid );

		$query = 'UPDATE #__modules'
		. ' SET published = ' . intval( $publish )
		. ' WHERE id IN ( '.$cids.' )'
		. ' AND ( checked_out = 0 OR ( checked_out = '.(int) $user->get('id').' ) )'
		;
		$db->setQuery( $query );
		if (!$db->query()) {
			return JError::raiseWarning( 500, $db->getErrorMsg() );
		}

		if (count( $cid ) == 1) {
			$row =& JTable::getInstance('module');
			$row->checkin( $cid[0] );
		}
	}

	/**
	 * Cancels an edit operation
	 */
	function cancel()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize some variables
		$db		=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$row =& JTable::getInstance('module');
		// ignore array elements
		$row->bind(JRequest::get('post'), 'selections params' );
		$row->checkin();
	}

	/**
	 * Moves the order of a record
	 */
	function reorder()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize some variables
		$db		=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		$task	= $this->getTask();
		$inc	= ($task == 'orderup' ? -1 : 1);

		if (empty( $cid )) {
			return JError::raiseWarning( 500, 'No items selected' );
		}

		$row =& JTable::getInstance('module');
		$row->load( (int) $cid[0] );

		$row->move( $inc, 'position = '.$db->Quote( $row->position ).' AND client_id='.(int) $client->id  );
	}

	/**
	 * Changes the access level of a record
	 */
	function access()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize some variables
		$db		=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		$task	= JRequest::getCmd( 'task' );

		if (empty( $cid )) {
			return JError::raiseWarning( 500, 'No items selected' );
		}

		switch ( $task )
		{
			case 'accesspublic':
				$access = 0;
				break;

			case 'accessregistered':
				$access = 1;
				break;

			case 'accessspecial':
				$access = 2;
				break;
		}

		$row =& JTable::getInstance('module');
		$row->load( (int) $cid[0] );
		$row->access = $access;

		if ( !$row->check() ) {
			JError::raiseWarning( 500, $row->getError() );
		}
		if ( !$row->store() ) {
			JError::raiseWarning( 500, $row->getError() );
		}
	}

	/**
	 * Saves the orders of the supplied list
	 */
	function saveOrder()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize some variables
		$db		=& JFactory::getDBO();
		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
// >>> (C) NoNumber! >>>
		$this->setRedirect( 'index.php?option=com_advancedmodules&client='.$client->id );
// <<< (C) NoNumber! <<<

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		if (empty( $cid )) {
			return JError::raiseWarning( 500, 'No items selected' );
		}

		$total		= count( $cid );
		$row 		=& JTable::getInstance('module');
		$groupings = array();

		$order 		= JRequest::getVar( 'order', array(0), 'post', 'array' );
		JArrayHelper::toInteger($order);

		// update ordering values
		for ($i = 0; $i < $total; $i++)
		{
			$row->load( (int) $cid[$i] );
			// track postions
			$groupings[] = $row->position;

			if ($row->ordering != $order[$i])
			{
				$row->ordering = $order[$i];
				if (!$row->store()) {
					return JError::raiseWarning( 500, $db->getErrorMsg() );
				}
			}
		}

		// execute updateOrder for each parent group
		$groupings = array_unique( $groupings );
		foreach ($groupings as $group){
			$row->reorder('position = '.$db->Quote($group).' AND client_id = '.(int) $client->id);
		}

		$this->setMessage (JText::_( 'New ordering saved' ));
	}

	function preview()
	{
		$document =& JFactory::getDocument();
		$document->setTitle(JText::_('Module Preview'));

// >>> (C) NoNumber! >>>
		require_once JApplicationHelper::getPath( 'admin_html' );
// <<< (C) NoNumber! <<<
		HTML_modules::preview( );
	}

// >>> (C) NoNumber! >>>
	/**
	* Displays a (multiple) selectbox of available sections and categories
	*/
	function fetchElementSecCats( $name, $value, $multiple = 1, $show_uncategorized = 1 )
	{
		$db =& JFactory::getDBO();

		if ( !is_array( $value ) ) {
			$value = explode( ',', $value );
		}

		$query = 'SELECT id, 0 as parent, title as name FROM #__sections WHERE published = 1 AND scope = "content" ORDER BY ordering';
		$db->setQuery( $query );
		$sections = $db->loadObjectList();
		for ( $i = 0; $i < count( $sections ); $i++ ) {
			$sec_name = explode( "\n",wordwrap( $sections[$i]->name, 86, "\n" ) );;
			$sec_name = $sec_name['0'];
			$sec_name = ( $sec_name != $sections[$i]->name ) ? $sec_name.'...' : $sec_name;
			$sections[$i]->title = $sec_name;
		}

		$children = array();
		$children[] = $sections;
		foreach ( $sections as $section ) {
			$query = 'SELECT CONCAT( '.$section->id.', ".", id ) as id, section as parent, title as name'
				.' FROM #__categories'
				.' WHERE published = 1'
				.' AND section = '.$section->id
				.' ORDER BY ordering';
			$db->setQuery( $query );
			$categories = $db->loadObjectList();
			for ( $i = 0; $i < count( $categories ); $i++ ) {
				$cat_name = explode( "\n",wordwrap( $categories[$i]->name, 86, "\n" ) );;
				$cat_name = $cat_name['0'];
				$cat_name = ( $cat_name != $categories[$i]->name ) ? $cat_name.'...' : $cat_name;
				$categories[$i]->name = $cat_name;
				if ( in_array( $section->id, $value ) ) {
					$value[] = $categories[$i]->id;
				}
			}
			$children[$section->id] = $categories;
		}

		// second pass - get an indent list of the items
		$list = JHTML::_( 'menu.treerecurse', 0, '', array(), $children, 9999, 0, 0 );

		// assemble items to the array
		$options =	array();
		if ( $show_uncategorized ) {
			$options[] = JHTML::_( 'select.option', '0', JText::_('Uncategorized'), 'value', 'text', 0 );
		}
		foreach ( $list as $item )
		{
			$options[] = JHTML::_( 'select.option', $item->id, $item->treename, 'value', 'text', 0 );
		}

		$attribs = 'class="inputbox"';
		$attribs .= ' size="'.( ( count( $options) > 10 ) ? 10 : count( $options) ).'"';
		if( $multiple ) $attribs .= ' multiple';

		return JHTML::_( 'select.genericlist', $options, 'advancedparams['.$name.'][]', $attribs, 'value', 'text', $value, 'advancedparams_'.$name );
	}

	/**
	* Displays an article id field with a button
	*/
	function fetchElementArticles( $name, $value, $_size = 1, $_multiple = 1 )
	{
		JHTML::_( 'behavior.modal', 'a.modal' );

		$_doc =& JFactory::getDocument();
		$_js = "
			function jSelectArticle( id, title, object ) {
				document.getElementById(object).value = document.getElementById(object).value.trim();
				if ( document.getElementById(object).value ) {
					 document.getElementById(object).value += ',';
				}
				document.getElementById(object).value += id;
				document.getElementById('sbox-window').close();
			}";
		$_doc->addScriptDeclaration( $_js );

		$_link = 'index.php?option=com_content&amp;task=element&amp;tmpl=component&amp;object=advancedparams_'.$name;

		$html = "\n".'<div style="float: left;">';
		$html 	.= '<input type="text" name="advancedparams['.$name.']" id="advancedparams_'.$name.'" value="'.$value.'" class="inputbox" />';

		$html .= '</div>';
		$html .= '<div class="button2-left"><div class="blank"><a class="modal" title="'.JText::_('Select an Article').'"  href="'.$_link.'" rel="{handler: \'iframe\', size: {x: 650, y: 375}}">'.JText::_('Select').'</a></div></div>'."\n";

		return $html;
	}

	/**
	* Displays a select box of backend group levels
	*/
	function fetchElementUserGroupLevels( $name, $value, $root = 'USERS', $showroot = '', $multiple = 1, $notregistered = 1 )
	{
		$control = 'advancedparams['.$name.']';
		$attribs = 'class="inputbox"';

		$acl		=& JFactory::getACL();
		$options =	$acl->get_group_children_tree( null, $root, $showroot );
		if ( $notregistered ) {
			$no_user =			'';
			$no_user->value =	0;
			$no_user->text =	'&nbsp; '.JText::_( 'Not logged in' );
			$no_user->disable =	'';
			array_unshift( $options, $no_user );
		}

		if ( $multiple ) {
			if( !is_array( $value ) ) {
				$value = explode( ',', $value );
			}
			$root_options = array();
			foreach( $options as $option ) {
				$query =
					'SELECT parent_id'
					.' FROM #__core_acl_aro_groups'
					.' WHERE id = '. (int) $option->value
					;
				$acl->db->setQuery( $query );
				$parent = $acl->db->loadResult();
				if ( $parent ) {
					$query =
						'SELECT name'
						.' FROM #__core_acl_aro_groups'
						.' WHERE id = '. (int) $parent
						;
					$acl->db->setQuery( $query );
					$parent_name = $acl->db->loadResult();
					/* is root element */
					if ( $parent_name == $root) {
						$option_name = $acl->get_group_name( $option->value );
						$children = $acl->_getBelow( '#__core_acl_aro_groups', 'g1.id, g1.name', 'g1.id', null, $option_name, false );
						$child_values = array();
						foreach ( $children as $child ) {
							$child_values[] = $child->id;
						}
						$root_options[$option->value] = $child_values;
					}
				}
			}
			if ( count( $root_options ) ) {
				$document =& JFactory::getDocument();
				$fors = array();
				foreach ( $root_options as $option => $values ) {
					$fors[] = ' ( selected == '.$option.' && ('
						.' option.value == '.implode( ' || option.value == ', $values )
						.' ) )';
				}
				$script = '
					function selectChildren_advancedparams'.$name.'()
					{
						var el = $(\'advancedparams'.$name.'\');
						var selected_option = el.getValue();
						el.getValue().each(function(selected) {
							$$(el.options).each(function(option) {
								if ( '.implode( ' || ', $fors ).') {
									option.selected = true;
								}
							});
						});
					}
					window.addEvent( \'domready\', function() { selectChildren_advancedparams'.$name.'(); });
				';
				$document->addScriptDeclaration( $script );
				$attribs .= ' onchange="selectChildren_advancedparams'.$name.'();" onload="alert("bla");selectChildren_advancedparams'.$name.'();"';
			}

			$attribs .= ' multiple="multiple"';
			$control .= '[]';
		}

		return JHTML::_( 'select.genericlist', $options, $control, $attribs, 'value', 'text', $value, 'advancedparams'.$name );
	}

	/**
	* Displays a list of components with check boxes
	*/
	function fetchElementComponents( $name, $value, $frontend = 1, $admin = 0, $show_content = 1 )
	{
		$components = $this->getComponents( $frontend, $admin, $show_content );

		// place a dummy hidden checkbox item in the list, to be able to deselect all (and still have a default)
		$list = "\n".'<input type="hidden" id="advancedparams'.$name.'x" name="advancedparams['.$name.']'.'[]" value="x" checked="checked" />';
		if ( count( $components ) ) {
			foreach ( $components as $component ) {
				if ( ! is_array( $value ) ) $value = explode( ',', $value );
				$checked = ( in_array( $component->option, $value ) ) ? ' checked="checked"' : '';
				$list .= "\n".'<input type="checkbox" id="advancedparams'.$name.$component->option.'" name="advancedparams['.$name.']'.'[]" value="'.$component->option.'"'.$checked.' />';
				$list .= $component->name.'<br />';
			}
		} else {
			$list .= JText::_( 'Component Not Found' );
		}

		return $list;
	}

	function getComponents( $frontend = 1, $admin = 0, $show_content = 1 )
	{
		$db   =& JFactory::getDBO();

		if ( !$frontend && !$admin ) {
			$query = 'SELECT '.$db->NameQuote( 'option' ).', name'
				.' FROM #__components'
				.' WHERE enabled = 1'
				.' AND parent = 0'
				;
			if ( !$show_content ) {
				$query .= ' AND '.$db->NameQuote( 'option' ).' <> "com_content"';
			}
			$query .= ' ORDER BY name';
			$db->setQuery( $query );
			$components = $db->loadObjectList();
		} else {
			if ( $frontend ) {
				// component subs
				$query = 'SELECT parent'
					.' FROM #__components'
					.' WHERE enabled = 1'
					.' AND parent != 0';
					' AND link != ""';
					' ORDER BY ordering, name'
					;
				$db->setQuery( $query );
				$subcomponents = $db->loadResultArray();
				$subcomponents = array_unique( $subcomponents );

				// main components
				$query = 'SELECT id'
					.' FROM #__components'
					.' WHERE enabled = 1'
					.' AND parent = 0'
					.' AND ( link != ""'
					;
					if ( count( $subcomponents ) ) {
						$query .= ' OR id IN ( '.implode( ',', $subcomponents ).' )';
					}
				$query .= ' )';
				$query .= ' ORDER BY ordering, name';
				$db->setQuery( $query );
				$component_ids = $db->loadResultArray();
			}

			if ( $admin ) {
				// component subs
				$query = 'SELECT parent'
					.' FROM #__components'
					.' WHERE enabled = 1'
					.' AND parent != 0'
					.' AND admin_menu_link != ""'
					;
				$db->setQuery( $query );
				$subcomponents = $db->loadResultArray();
				$subcomponents = array_unique( $subcomponents );

				// main components
				$query = 'SELECT id'
					.' FROM #__components'
					.' WHERE enabled = 1'
					.' AND parent = 0'
					.' AND ( admin_menu_link != ""'
					;
					if ( count( $subcomponents ) ) {
						$query .= ' OR id IN ( '.implode( ',', $subcomponents ).' )';
					}
				$query .= ' )';
				$db->setQuery( $query );
				if ( $frontend ) {
					$component_ids = array_intersect( $component_ids, $db->loadResultArray() );
				} else {
					$component_ids = $db->loadResultArray();
				}
			}

			$component_ids = array_unique( $component_ids );
			$query = 'SELECT '.$db->NameQuote( 'option' ).', name'
				.' FROM #__components'
				.' WHERE enabled = 1'
				.' AND parent = 0'
				;
				if ( count( $component_ids ) ) {
					$query .= ' AND id IN ( '.implode( ',', $component_ids ).' )';
				}
				if ( !$show_content ) {
					$query .= ' AND '.$db->NameQuote( 'option' ).' <> "com_content"';
				}
			$query .= ' ORDER BY name';
			$db->setQuery( $query );
			$components = $db->loadObjectList();
		}

		return $components;
	}

	function getComponentsArray( $frontend = 1, $admin = 0, $show_content = 1 )
	{
		$components = $this->getComponents( $frontend, $admin, $show_content );
		$components = array();
		foreach ( $components as $component ) {
			$components[] = $component->option;
		}
		return $components;
	}
	/**
	* Displays a list of components with check boxes
	*/
	function fetchElementCalander( $name, $value, $format = '%Y-%m-%d', $class = 'inputbox' )
	{
		JHTML::_('behavior.calendar'); //load the calendar behavior

		$id   = 'advancedparams'.$name;
		$name = 'advancedparams['.$name.']';

		return JHTML::_('calendar', $value, $name, $id, $format, array('class' => $class));
	}
	/**
	* Displays a select box of languages
	*/
	function fetchElementLanguages( $name, $value )
	{
		if( !is_array( $value ) ) { $value = explode( ',', $value ); }

		jimport('joomla.language.helper');
		$options = JLanguageHelper::createLanguageList( $value, constant( 'JPATH_SITE' ), true );
		$attribs = 'class="inputbox" multiple="multiple" size="'.( ( count( $options) > 10 ) ? 10 : count( $options) ).'"';


		$list = JHTML::_( 'select.genericlist', $options, 'advancedparams['.$name.'][]', $attribs, 'value', 'text', $value, 'advancedparams'.$name );

		return $list;
	}
	/**
	* Displays a select box of templates
	*/
	function fetchElementTemplates( $name, $value )
	{
		require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_templates'.DS.'helpers'.DS.'template.php';
		$rows = array();
		$rows = TemplatesHelper::parseXMLTemplateFiles( JPATH_ROOT.DS.'templates' );

		$options = array();
		foreach ( $rows as $row ) {
			$option = '';
			$option->value =	$row->directory;
			$option->text =		$row->name;
			$option->disable =	null;
			$options[] = $option;
		}

		$attribs = 'class="inputbox" multiple="multiple" size="'.( ( count( $options) > 10 ) ? 10 : count( $options) ).'"';

		$list =	JHTML::_( 'select.genericlist', $options, 'advancedparams['.$name.'][]', $attribs, 'value', 'text', $value, 'advancedparams'.$name );

		return $list;
	}
// <<< (C) NoNumber! <<<
}