<?php
/**
 * Install File
 * Does the stuff for the specific extensions
 *
 * @package    Advanced Module Manager
 * @version    1.5.0c
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/advancedmodulemanager
 * @copyright  Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

$name = 'Advanced Module Manager';
$alias = 'advancedmodules';
$ext = $name.' (admin component & system plugin)';

// COMPONENT
	$queries = array();
	// main table (not used in this version yet)
	$queries[] = "CREATE TABLE IF NOT EXISTS `#__".$alias."` (
		`id` int(11) unsigned NOT NULL auto_increment,
		`moduleid` int(11) NOT NULL default '0',
		`params` text NOT NULL,
		PRIMARY KEY  (`id`,`moduleid`)
	)";
	// extra association table (for excluded menu items)
	$queries[] = "CREATE TABLE IF NOT EXISTS `#__".$alias."_menu` (
		`moduleid` int(11) NOT NULL DEFAULT '0',
		`menuid` int(11) NOT NULL DEFAULT '0',
		PRIMARY KEY  (`moduleid`,`menuid`)
	)";

	// fix the published = 2 from the first patch version
	$queries[] = "UPDATE `#__modules`
		SET `published` = 1
		WHERE `published` = 2";

	// Rename old plugin name
	$queries[] = "UPDATE `#__components`
		SET	`name` = 'Advanced Module Manager',
			`admin_menu_alt` = 'Advanced Module Manager'
		WHERE `name` = 'Advanced Modules'";

	$states[] = installExtension( $alias, $name, 'component', array( 'link'=>'', 'admin_menu_link'=>'' ), $queries );

// SYSTEM PLUGIN
	$queries = array();
	// Rename old plugin name
	$queries[] = "UPDATE `#__plugins`
		SET `name` = 'System - Advanced Module Manager'
		WHERE `name` = 'System - Advanced Modules'";

	$states[] = installExtension( $alias, 'System - '.$name, 'plugin', array( 'folder'=>'system' ), $queries );