<?php
/**
 * @version		$Id: modules.php 10822 2008-08-27 17:16:00Z tcp $
 * @package		Joomla
 * @copyright	Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * This is a file to add template specific chrome to module rendering.  To use it you would
 * set the style attribute for the given module(s) include in your template to use the style
 * for each given modChrome function.
 *
 * eg.  To render a module mod_test in the sliders style, you would use the following include:
 * <jdoc:include type="module" name="test" style="slider" />
 *
 * This gives template designers ultimate control over how modules are rendered.
 *
 * NOTICE: All chrome wrapping methods should be named: modChrome_{STYLE} and take the same
 * two arguments.
 */

/*
 * Module chrome for rendering the module in a slider
 */
function modChrome_slider($module, &$params, &$attribs)
{
	jimport('joomla.html.pane');
	// Initialize variables
	$sliders = & JPane::getInstance('sliders');
	$sliders->startPanel( JText::_( $module->title ), 'module' . $module->id );
	echo $module->content;
	$sliders->endPanel();
}

/*
 * Module chrome that allows for rounded corners by wrapping in nested div tags
 */
function modChrome_jarounded($module, &$params, &$attribs)
{ ?>
		<div class="jamod module<?php echo $params->get('moduleclass_sfx'); ?>" id="Mod<?php echo $module->id; ?>">
			<div>
				<div>
					<div>
						<?php if ($module->showtitle != 0) : ?>
						<?php
						if(isset($_COOKIE['Mod'.$module->id])) $modhide = $_COOKIE['Mod'.$module->id];
						else $modhide = 'show';
						?>
						<h3 class="<?php echo $modhide; ?>"><span><?php echo $module->title; ?></span></h3>
						<?php endif; ?>
						<div class="jamod-content"><?php echo $module->content; ?></div>
					</div>
				</div>
			</div>
		</div>
	<?php
}
?>
<?php
function modChrome_freditor($module,&$params,&$attribs)
{
	// Check if user has permissions to manage modules
	$user = &JFactory::getUser();
	$canEditModule = $user->authorize('com_modules','manage');
	
	// Check if module editing is enabled 
	$db =& JFactory::getDBO();
	$query = "SELECT * FROM #__frsettings WHERE id = 1";
	$db->setQuery($query);
	$data = $db->loadObject();
	
	if($data->module_edit && $canEditModule)
	{
		if($module->showtitle)
		{
			$style = "position:relative;float:right;margin-right:5px";
		}
		else
		{
			$style = "position:absolute;display:none";
		}
		?>
		<div class="mod-edit" id = "module.<?php echo $module->id ?>" name="<?php echo $module->title ?>">
			<a class='fr_editicon' style="<?php echo $style; ?>" href='index.php?option=com_frontendeditor&c=module&task=edit&tmpl=component&cid[]=<?php echo $module->id?>' rel="{handler:'iframe',iframePreload:true,size:{x:800,y:570},sizeLoading:{x:800,y:570},onOpen:JEdit.onModalOpen}">
			</a>
			<?php echo $module->content; ?>
		</div>	
	<?php
	} 
	else
	{
		echo $module->content;
	}
}
?>