<?php
/**
 * Plugin Helper File
 *
 * @package    Advanced Module Manager
 * @version    1.5.0c
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/advancedmodulemanager
 * @copyright  Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
* Plugin that gives advanced features for modules
*/
class plgSystemAdvancedModulesHelper
{
	/*
	 * Place slider with active modules for given Itemid
	 */
	function showModulesByItemid( $id )
	{
		$document	=& JFactory::getDocument();

		if (
			!isset( $document->_buffer ) ||
			!isset( $document->_buffer['component'] ) ||
			!is_array( $document->_buffer['component'] ) ||
			!count( $document->_buffer['component'] )
		) {
			return;
		}

		$lang = & JFactory::getLanguage();
		// load plugin language file
		$lang->load( 'plg_system_advancedmodules', JPATH_ADMINISTRATOR );

		jimport('joomla.html.pane');
		$slider = &JPane::getInstance( 'sliders', array( 'allowAllClose' => true ) );

		$pane = $slider->startPanel( JText :: _( 'Active Modules' ), "advancedmodules-page" );
		$pane .= $this->getModulesTable( $id );
		$pane .= $slider->endPanel();

		$s = '(<div [^>]*id="menu-pane"[^>]*>.*)(<\/div>.*<\/td>.*<\/table>.*<\/form>)';
		$r = '\1'.$pane.'\2';

		foreach( $document->_buffer['component'] as $i => $buffer ) {
			$document->_buffer['component'][$i] = preg_replace( '#'.$s.'#si', $r, $buffer );
		}
	}

	function getModulesTable( $id )
	{
		JHTML::_('behavior.modal');

		$user =& JFactory::getUser();
		$modules = $this->getAdvancedModules( $id );

		if ( !count( $modules ) ) {
			return '<p style="text-align:center;">'.JText::_( 'No active modules' ).'</p>';
		}

		$table = '
			<table class="adminlist" cellspacing="1">
				<thead>
					<tr>
						<th>'.JText::_( 'Module Name' ).'</th>
						<th>'.JText::_( 'Position' ).'</th>
						<th>'.JText::_( 'Type' ).'</th>
						<th>'.JText::_( 'Access' ).'</th>
						<th>'.JText::_( 'ID' ).'</th>
					</tr>
				</thead>
				<tbody>';
		foreach ( $modules as $module ) {
			$access = JHTML::_('grid.access', $module, NULL, 1 );
			if (  JTable::isCheckedOut( $user->get('id'), $module->checked_out ) ) {
				$title = $module->title;
			} else {
				$link = JRoute::_( 'index.php?option=com_advancedmodules&client=0&task=edit&tmpl=component&cid[]='. $module->id );
				$title = '
					<span class="editlinktip hasTip" title="'.JText::_( 'Edit Module' ).'::'.$module->title.'">
						<a href="'.$link.'" class="modal" rel="{handler: \'iframe\', size: {x: 700, y: 550}}">'.$module->title.'</a>
					</span>';
			}
			$table .= '
					<tr>
						<td>'.$title.'</td>
						<td>'.$module->position.'</td>
						<td>'.$module->module.'</td>
						<td>'.$access.'</td>
						<td>'.$module->id.'</td>
					</tr>';
		}
		$table .= '
				</tbody>
			</table>';

		return $table;

	}

	function getAdvancedModules( $Itemid )
	{
		$db =& JFactory::getDBO();

		$query = 'SELECT m.id, m.title, m.module, m.position, m.checked_out, m.access, g.name AS groupname'
			. ' FROM #__modules AS m'
			. ' LEFT JOIN #__groups AS g ON g.id = m.access'
			. ' WHERE m.published = 1'
			. ' AND m.client_id = 0'
			. ' GROUP BY m.id'
			. ' ORDER BY m.position, m.ordering';

		$db->setQuery( $query );

		if ( null === ( $modules = $db->loadObjectList( 'id' ) ) ) {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_( 'Error Loading Modules' ) . $db->getErrorMsg());
			return false;
		}

		$in_statement = implode(', ', array_keys( $modules ) ) ;

		// START BLOCK: Imperial Valley College Contribution by Omar Ramos
		$query = 'SELECT menuid, moduleid'
			. ' FROM #__advancedmodules_menu'
			. ' WHERE moduleid IN (' . $in_statement . ')';
		$db->setQuery( $query );
		$primaryLookupList = $this->groupBy( $db->loadObjectList(), 'moduleid', 'menuid' );

		$query = 'SELECT menuid, moduleid'
			. ' FROM #__modules_menu'
			. ' WHERE moduleid IN (' . $in_statement . ')';
		$db->setQuery( $query );
		$alternativeLookupList = $this->groupBy( $db->loadObjectList(), 'moduleid', 'menuid' );

		foreach ( $modules as $id => $module ) {
			$lookup = isset( $primaryLookupList[$module->id] ) ? $primaryLookupList[$module->id] : array();
			if ( count( $lookup ) ) {
				if ( in_array( $Itemid, $lookup ) ) {
					unset( $modules[$id] );
				}
			} else {
				$lookup = isset( $alternativeLookupList[$module->id] ) ? $alternativeLookupList[$module->id] : array();
				if ( !in_array( $Itemid, $lookup ) && !in_array( '0', $lookup ) ) {
					unset( $modules[$id] );
				}
			}
		}
		// END BLOCK: Imperial Valley College Contribution by Omar Ramos

		sort( $modules );

		return $modules;
	}

	/*
	 * Replace links to com_modules with com_advancedmodules
	 */
	function replaceComponentLinks()
	{
		$document	=& JFactory::getDocument();

		$html = preg_replace( '#(option=com_)(modules[^a-z-_])#', '\1advanced\2', JResponse::getBody() );

		JResponse::setBody( $html );
	}

	function groupBy( $list, $fieldName, $fieldNameToKeep = null )
	{
		$grouped = array();
		if ( !is_array( $list ) ) {
			if ( $list == '' ) { return $grouped; }
			$list = array( $list );
		}
		foreach( $list as $key => $item ) {
			if ( !isset( $grouped[$item->$fieldName] ) ) {
				$grouped[$item->$fieldName] = array();
			}
			if ( is_null( $fieldNameToKeep ) ) {
				$grouped[$item->$fieldName][] = $item;
			} else {
				$grouped[$item->$fieldName][] = $item->$fieldNameToKeep;
			}
			unset( $list[$key] );
		}

		return $grouped;
	}
}