<?php
/**
* Pausing up-down Scroller plugin
* This is a plugin that displays an up-down scroller that pauses between each
* message! The look of the scroller is completely styled using external CSS,
* including the dimensions. Easily create a single line scroller just by
* adjusting the scroller's height appropriately!
* Author: kksou
* Copyright (C) 2006-2008. kksou.com. All Rights Reserved
* Website: http://www.kksou.com/php-gtk2/Joomla-Gadgets/
* v1.5 December 3, 2008
* v1.51 December 19, 2008 modified the codes slightly so that it can be used with mod_pausing_up_down_scroller
*/

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.event.plugin' );

$lib = dirname(__FILE__).'/pausing_up_down_scroller/pausing_up_down_scroller.lib.php';
require_once($lib);

class plgContentpausing_up_down_scroller extends JPlugin {

	function plgContentpausing_up_down_scroller( &$subject, $params ) {
		parent::__construct( $subject, $params );
 	}

	function onPrepareContent( &$row, &$params, $limitstart=0 ) {

		$plugin = new Plugin_PausingUpDownScroller($row);

		return true;
	}
}

class Plugin_PausingUpDownScroller extends PausingUpDownScroller {

	function Plugin_PausingUpDownScroller( &$row ) {
		$regex = '%\{UpDownScroller\s*(.*?)\s*\}(\n|\r\n|</p>|<p>|&nbsp;|<br\s/>)*(.*?)(\n|\r\n|</p>|<p>|&nbsp;|<br\s/>)*\{/UpDownScroller\}%is';

		$module = 'pausing_up_down_scroller';
		$this->get_param($module, '1.5');

		$plugin =& JPluginHelper::getPlugin('content', $module);
		if (isset($plugin->params)) {
			$pluginParams = new JParameter( $plugin->params );
			if ( !$pluginParams->get( 'enabled', 1 ) ) {
				$row->text = preg_replace( $regex, '', $row->text );
				return true;
			}
		}

		$contents = $row->text;
		if (preg_match_all( $regex, $contents, $matches_array, PREG_SET_ORDER )) {
			$count = count( $matches_array[0] );
			if ($count==0) return true;
			foreach($matches_array as $matches) {
				$this->process($row, $matches);
			}
			#$row->text = preg_replace( $regex, '', $row->text );
		}
		return true;
	}

}

?>
